/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.Writer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.TextPosition;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.AbstractPDF2XHTML;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class OCR2XHTML
extends AbstractPDF2XHTML {
    private OCR2XHTML(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        super(document, handler, context, metadata, config);
    }

    public static void process(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws SAXException, TikaException {
        OCR2XHTML ocr2XHTML = null;
        try {
            ocr2XHTML = new OCR2XHTML(document, handler, context, metadata, config);
            ocr2XHTML.writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", e);
        }
        if (ocr2XHTML.exceptions.size() > 0) {
            throw new TikaException("Unable to extract all PDF content", (Throwable)ocr2XHTML.exceptions.get(0));
        }
    }

    @Override
    public void processPage(PDPage pdPage) throws IOException {
        try {
            this.startPage(pdPage);
            this.doOCROnCurrentPage(PDFParserConfig.OCR_STRATEGY.OCR_ONLY);
            this.endPage(pdPage);
        }
        catch (TikaException | SAXException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            this.handleCatchableIOE(e);
        }
    }

    @Override
    protected void writeString(String text) throws IOException {
    }

    @Override
    protected void writeCharacters(TextPosition text) throws IOException {
    }

    @Override
    protected void writeWordSeparator() throws IOException {
    }

    @Override
    protected void writeLineSeparator() throws IOException {
    }
}

