/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.wordperfect.QPWTextExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class QuattroProParser
extends AbstractParser {
    private static final long serialVersionUID = 8941810225917012232L;
    private static final MediaType QP_BASE = MediaType.application("x-quattro-pro");
    public static final MediaType QP_9 = new MediaType(QP_BASE, "version", "9");
    public static final MediaType QP_7_8 = new MediaType(QP_BASE, "version", "7-8");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(QP_9);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (metadata.get("Content-Type") == null) {
            metadata.set("Content-Type", QP_9.toString());
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        QPWTextExtractor extractor = new QPWTextExtractor();
        extractor.extract(stream, xhtml, metadata);
        xhtml.endDocument();
    }
}

