/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.extensions.yui.YuiLib;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converters.DateConverter;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePicker
extends AbstractBehavior
implements IHeaderContributor {
    private static Method GETINSTANCEMETHOD = null;
    public static String FORMAT_DATE;
    public static String FORMAT_PAGEDATE;
    private static final ResourceReference YUI;
    private static final ResourceReference WICKET_DATE;
    private static final long serialVersionUID = 1L;
    private Component component;
    private boolean showOnFieldClick = false;

    public void bind(Component component) {
        this.component = component;
        this.checkComponentProvidesDateFormat(component);
        component.setOutputMarkupId(true);
    }

    public void onRendered(Component component) {
        super.onRendered(component);
        Response response = component.getResponse();
        response.write((CharSequence)"\n<span class=\"yui-skin-sam\">&nbsp;<span style=\"");
        if (this.renderOnLoad()) {
            response.write((CharSequence)"display:block;");
        } else {
            response.write((CharSequence)"display:none;");
            response.write((CharSequence)"position:absolute;");
        }
        response.write((CharSequence)"z-index: 99999;\" id=\"");
        response.write((CharSequence)this.getEscapedComponentMarkupId());
        response.write((CharSequence)"Dp\"></span><img style=\"");
        response.write((CharSequence)this.getIconStyle());
        response.write((CharSequence)"\" id=\"");
        response.write((CharSequence)this.getIconId());
        response.write((CharSequence)"\" src=\"");
        CharSequence iconUrl = this.getIconUrl();
        response.write(Strings.escapeMarkup((String)(iconUrl != null ? ((Object)iconUrl).toString() : "")));
        response.write((CharSequence)"\" alt=\"");
        CharSequence alt = this.getIconAltText();
        response.write(Strings.escapeMarkup((String)(alt != null ? ((Object)alt).toString() : "")));
        response.write((CharSequence)"\" title=\"");
        CharSequence title = this.getIconTitle();
        response.write(Strings.escapeMarkup((String)(title != null ? ((Object)title).toString() : "")));
        response.write((CharSequence)"\"/>");
        if (this.renderOnLoad()) {
            response.write((CharSequence)"<br style=\"clear:left;\"/>");
        }
        response.write((CharSequence)"</span>");
    }

    protected boolean includeYUILibraries() {
        return true;
    }

    public void renderHead(IHeaderResponse response) {
        if (this.includeYUILibraries()) {
            YuiLib.load(response);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String widgetId = this.getEscapedComponentMarkupId();
        variables.put("componentId", this.getComponentMarkupId());
        variables.put("widgetId", widgetId);
        variables.put("datePattern", this.getDatePattern());
        variables.put("fireChangeEvent", this.notifyComponentOnDateSelected());
        variables.put("alignWithIcon", this.alignWithIcon());
        variables.put("hideOnSelect", this.hideOnSelect());
        variables.put("showOnFieldClick", this.showOnFieldClick());
        variables.put("basePath", Strings.stripJSessionId((CharSequence)RequestCycle.get().urlFor(YUI)));
        variables.put("wicketDatePath", RequestCycle.get().urlFor(WICKET_DATE));
        if ("development".equals(Application.get().getConfigurationType())) {
            variables.put("filter", "filter: \"RAW\",");
            variables.put("allowRollup", false);
        } else {
            variables.put("filter", "");
            variables.put("allowRollup", true);
        }
        String script = this.getAdditionalJavascript();
        if (script != null) {
            variables.put("additionalJavascript", Strings.replaceAll((CharSequence)script, (CharSequence)"${calendar}", (CharSequence)("YAHOO.wicket." + widgetId + "DpJs")));
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        this.configure(p);
        if (!p.containsKey("navigator") && this.enableMonthYearSelection()) {
            p.put("navigator", Boolean.TRUE);
        }
        if (this.enableMonthYearSelection() && p.containsKey("pages") && Objects.longValue(p.get("pages")) > 1L) {
            throw new IllegalStateException("You cannot use a CalendarGroup with month/year selection!");
        }
        StringBuffer calendarInit = new StringBuffer();
        Iterator i = p.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            calendarInit.append((String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof CharSequence) {
                calendarInit.append(":\"");
                calendarInit.append(Strings.toEscapedUnicode((String)value.toString()));
                calendarInit.append("\"");
            } else if (value instanceof CharSequence[]) {
                calendarInit.append(":[");
                CharSequence[] valueArray = (CharSequence[])value;
                for (int j = 0; j < valueArray.length; ++j) {
                    CharSequence tmpValue = valueArray[j];
                    if (j > 0) {
                        calendarInit.append(",");
                    }
                    if (tmpValue == null) continue;
                    calendarInit.append("\"");
                    calendarInit.append(Strings.toEscapedUnicode((String)((Object)tmpValue).toString()));
                    calendarInit.append("\"");
                }
                calendarInit.append("]");
            } else if (value instanceof Map) {
                calendarInit.append(":");
                Map map = (Map)value;
                this.appendMapping(map, calendarInit);
            } else {
                calendarInit.append(":");
                calendarInit.append(Strings.toEscapedUnicode((String)String.valueOf(value)));
            }
            if (!i.hasNext()) continue;
            calendarInit.append(",");
        }
        variables.put("calendarInit", calendarInit.toString());
        PackagedTextTemplate datePickerJs = new PackagedTextTemplate(DatePicker.class, "DatePicker.js");
        datePickerJs.interpolate(variables);
        response.renderOnDomReadyJavascript(datePickerJs.asString());
        if (AjaxRequestTarget.get() != null) {
            String escapedComponentMarkupId = this.getEscapedComponentMarkupId();
            String javascript = "var e = Wicket.$('" + escapedComponentMarkupId + "Dp" + "'); if (e != null && typeof(e.parentNode) != 'undefined' && " + "typeof(e.parentNode.parentNode != 'undefined')) " + "e.parentNode.parentNode.removeChild(e.parentNode);" + "YAHOO.wicket." + escapedComponentMarkupId + "DpJs.destroy(); delete YAHOO.wicket." + escapedComponentMarkupId + "DpJs;";
            response.renderJavascript((CharSequence)javascript, null);
        }
    }

    private final void checkComponentProvidesDateFormat(Component component) {
        if (this.getDatePattern() == null) {
            throw new UnableToDetermineFormatException();
        }
    }

    private void setWidgetProperty(Map<String, Object> widgetProperties, String key, String[] array) {
        if (array != null && array.length > 0) {
            widgetProperties.put(key, array);
        }
    }

    protected boolean alignWithIcon() {
        return true;
    }

    protected void configure(Map<String, Object> widgetProperties) {
        widgetProperties.put("close", true);
        this.localize(widgetProperties);
        Object modelObject = this.component.getDefaultModelObject();
        if (modelObject instanceof Date) {
            Date date = (Date)modelObject;
            widgetProperties.put("selected", new SimpleDateFormat(FORMAT_DATE).format(date));
            widgetProperties.put("pagedate", new SimpleDateFormat(FORMAT_PAGEDATE).format(date));
        }
    }

    @Deprecated
    protected final void configureWidgetProperties(Map<String, Object> widgetProperties) {
        throw new UnsupportedOperationException("");
    }

    protected final String[] filterEmpty(String[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (Strings.isEmpty((CharSequence)array[i])) continue;
            l.add(array[i]);
        }
        return l.toArray(new String[l.size()]);
    }

    protected final String getComponentMarkupId() {
        return this.component.getMarkupId();
    }

    protected String getDatePattern() {
        String format = null;
        if (this.component instanceof AbstractTextComponent.ITextFormatProvider) {
            format = ((AbstractTextComponent.ITextFormatProvider)this.component).getTextFormat();
        }
        if (format == null) {
            IConverter converter = this.component.getConverter(DateTime.class);
            if (!(converter instanceof DateConverter)) {
                converter = this.component.getConverter(Date.class);
            }
            format = ((SimpleDateFormat)((DateConverter)converter).getDateFormat(this.component.getLocale())).toPattern();
        }
        return format;
    }

    protected final String getEscapedComponentMarkupId() {
        return this.component.getMarkupId().replaceAll("\\W", "");
    }

    protected final String getIconId() {
        return this.getEscapedComponentMarkupId() + "Icon";
    }

    protected String getIconStyle() {
        return "cursor: pointer; border: none;";
    }

    protected CharSequence getIconTitle() {
        return "";
    }

    protected CharSequence getIconAltText() {
        return "";
    }

    protected CharSequence getIconUrl() {
        return RequestCycle.get().urlFor(new ResourceReference(DatePicker.class, "icon1.gif"));
    }

    protected Locale getLocale() {
        return this.component.getLocale();
    }

    protected void localize(Map<String, Object> widgetProperties) {
        DateFormatSymbols dfSymbols = null;
        if (GETINSTANCEMETHOD != null) {
            try {
                dfSymbols = (DateFormatSymbols)GETINSTANCEMETHOD.invoke(null, this.getLocale());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dfSymbols == null) {
            dfSymbols = new DateFormatSymbols(this.getLocale());
        }
        this.setWidgetProperty(widgetProperties, "MONTHS_SHORT", this.filterEmpty(dfSymbols.getShortMonths()));
        this.setWidgetProperty(widgetProperties, "MONTHS_LONG", this.filterEmpty(dfSymbols.getMonths()));
        this.setWidgetProperty(widgetProperties, "WEEKDAYS_MEDIUM", this.filterEmpty(dfSymbols.getShortWeekdays()));
        this.setWidgetProperty(widgetProperties, "WEEKDAYS_LONG", this.filterEmpty(dfSymbols.getWeekdays()));
        widgetProperties.put("START_WEEKDAY", new Integer(Calendar.getInstance(this.getLocale()).getFirstDayOfWeek() - 1));
        if (Locale.SIMPLIFIED_CHINESE.equals(this.getLocale()) || Locale.TRADITIONAL_CHINESE.equals(this.getLocale())) {
            this.setWidgetProperty(widgetProperties, "WEEKDAYS_1CHAR", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 2, 1)));
            widgetProperties.put("WEEKDAYS_SHORT", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 2, 1)));
        } else {
            this.setWidgetProperty(widgetProperties, "WEEKDAYS_1CHAR", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 0, 1)));
            this.setWidgetProperty(widgetProperties, "WEEKDAYS_SHORT", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 0, 2)));
        }
    }

    protected boolean notifyComponentOnDateSelected() {
        return true;
    }

    protected final String[] substring(String[] array, int len) {
        return this.substring(array, 0, len);
    }

    protected final String[] substring(String[] array, int start, int len) {
        if (array != null) {
            String[] copy = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                String el = array[i];
                if (el == null) continue;
                copy[i] = el.length() > start + len ? el.substring(start, start + len) : el;
            }
            return copy;
        }
        return null;
    }

    protected boolean enableMonthYearSelection() {
        return false;
    }

    protected boolean hideOnSelect() {
        return true;
    }

    protected boolean showOnFieldClick() {
        return this.showOnFieldClick;
    }

    public DatePicker setShowOnFieldClick(boolean show) {
        this.showOnFieldClick = show;
        return this;
    }

    protected boolean renderOnLoad() {
        return false;
    }

    protected String getAdditionalJavascript() {
        return "";
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    private void appendMapping(Map<String, ?> map, StringBuffer calendarInit) {
        boolean first = true;
        calendarInit.append("{");
        for (String key : map.keySet()) {
            if (first) {
                first = false;
            } else {
                calendarInit.append(",");
            }
            calendarInit.append(Strings.toEscapedUnicode((String)key));
            calendarInit.append(":");
            if (map.get(key) instanceof Map) {
                Map value = (Map)map.get(key);
                this.appendMapping(value, calendarInit);
                continue;
            }
            calendarInit.append("\"");
            calendarInit.append(Strings.toEscapedUnicode((String)map.get(key).toString()));
            calendarInit.append("\"");
        }
        calendarInit.append("}");
    }

    static {
        try {
            GETINSTANCEMETHOD = DateFormatSymbols.class.getMethod("getInstance", Locale.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FORMAT_DATE = "MM/dd/yyyy";
        FORMAT_PAGEDATE = "MM/yyyy";
        YUI = new JavascriptResourceReference(YuiLib.class, "");
        WICKET_DATE = new JavascriptResourceReference(DatePicker.class, "wicket-date.js");
    }

    private static final class UnableToDetermineFormatException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToDetermineFormatException() {
            super("This behavior can only be added to components that either implement " + AbstractTextComponent.ITextFormatProvider.class.getName() + " AND produce a non-null format, or that use" + " converters that this datepicker can use to determine" + " the pattern being used. Alternatively, you can extend " + " the date picker and override getDatePattern to provide your own");
        }
    }
}

