/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring;

import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringWebApplicationFactory
implements IWebApplicationFactory {
    public WebApplication createApplication(WicketFilter filter) {
        ServletContext sc = filter.getFilterConfig().getServletContext();
        WebApplicationContext ac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        String beanName = filter.getFilterConfig().getInitParameter("applicationBean");
        return this.createApplication((ApplicationContext)ac, beanName);
    }

    private WebApplication createApplication(ApplicationContext ac, String beanName) {
        if (beanName != null) {
            WebApplication application = (WebApplication)ac.getBean(beanName);
            if (application == null) {
                throw new IllegalArgumentException("Unable to find WebApplication bean with name [" + beanName + "]");
            }
            return application;
        }
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)ac, WebApplication.class, (boolean)false, (boolean)false);
        if (beans.size() == 0) {
            throw new IllegalStateException("bean of type [" + WebApplication.class.getName() + "] not found");
        }
        if (beans.size() > 1) {
            throw new IllegalStateException("more then one bean of type [" + WebApplication.class.getName() + "] found, must have only one");
        }
        return (WebApplication)beans.values().iterator().next();
    }
}

