/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.spring.injection.annot;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.proxy.LazyInitProxyFactory;
import org.apache.wicket.spring.ISpringContextLocator;
import org.apache.wicket.spring.SpringBeanLocator;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AnnotProxyFieldValueFactory
implements IFieldValueFactory {
    private final ISpringContextLocator contextLocator;
    private final ConcurrentHashMap<SpringBeanLocator, Object> cache = new ConcurrentHashMap();
    private final boolean wrapInProxies;

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator) {
        this(contextLocator, true);
    }

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator, boolean wrapInProxies) {
        if (contextLocator == null) {
            throw new IllegalArgumentException("[contextLocator] argument cannot be null");
        }
        this.contextLocator = contextLocator;
        this.wrapInProxies = wrapInProxies;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        if (field.isAnnotationPresent(SpringBean.class)) {
            SpringBean annot = field.getAnnotation(SpringBean.class);
            SpringBeanLocator locator = new SpringBeanLocator(annot.name(), field.getType(), this.contextLocator);
            if (this.cache.containsKey(locator)) {
                return this.cache.get(locator);
            }
            Object target = this.wrapInProxies ? LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator) : locator.locateProxyTarget();
            if (locator.isSingletonBean()) {
                this.cache.put(locator, target);
            }
            return target;
        }
        return null;
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(SpringBean.class);
    }
}

