/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.value;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.util.parse.metapattern.parsers.VariableAssignmentParser;
import org.apache.wicket.util.string.IStringIterator;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.IValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMap
extends LinkedHashMap<String, Object>
implements IValueMap {
    public static final ValueMap EMPTY_MAP = new ValueMap();
    private static final long serialVersionUID = 1L;
    private boolean immutable = false;

    public ValueMap() {
    }

    public ValueMap(Map<? extends String, ?> map) {
        super.putAll(map);
    }

    public ValueMap(String keyValuePairs) {
        this(keyValuePairs, ",");
    }

    public ValueMap(String keyValuePairs, String delimiter) {
        int start = 0;
        int equalsIndex = keyValuePairs.indexOf(61);
        int delimiterIndex = keyValuePairs.indexOf(delimiter, equalsIndex);
        if (delimiterIndex == -1) {
            delimiterIndex = keyValuePairs.length();
        }
        while (equalsIndex != -1) {
            if (delimiterIndex < keyValuePairs.length()) {
                int equalsIndex2 = keyValuePairs.indexOf(61, delimiterIndex + 1);
                delimiterIndex = equalsIndex2 != -1 ? keyValuePairs.lastIndexOf(delimiter, equalsIndex2) : keyValuePairs.length();
            }
            String key = keyValuePairs.substring(start, equalsIndex);
            String value = keyValuePairs.substring(equalsIndex + 1, delimiterIndex);
            this.add(key, value);
            if (delimiterIndex < keyValuePairs.length()) {
                start = delimiterIndex + 1;
                equalsIndex = keyValuePairs.indexOf(61, start);
                if (equalsIndex == -1 || (delimiterIndex = keyValuePairs.indexOf(delimiter, equalsIndex)) != -1) continue;
                delimiterIndex = keyValuePairs.length();
                continue;
            }
            equalsIndex = -1;
        }
    }

    public ValueMap(String keyValuePairs, String delimiter, MetaPattern valuePattern) {
        StringList pairs = StringList.tokenize(keyValuePairs, delimiter);
        IStringIterator iterator = pairs.iterator();
        while (iterator.hasNext()) {
            String pair = iterator.next();
            VariableAssignmentParser parser = new VariableAssignmentParser(pair, valuePattern);
            if (parser.matches()) {
                this.put(parser.getKey(), (Object)parser.getValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid key value list: '" + keyValuePairs + '\'');
        }
    }

    @Override
    public final void clear() {
        this.checkMutability();
        super.clear();
    }

    @Override
    public final boolean getBoolean(String key) throws StringValueConversionException {
        return this.getStringValue(key).toBoolean();
    }

    @Override
    public final double getDouble(String key) throws StringValueConversionException {
        return this.getStringValue(key).toDouble();
    }

    @Override
    public final double getDouble(String key, double defaultValue) throws StringValueConversionException {
        return this.getStringValue(key).toDouble(defaultValue);
    }

    @Override
    public final Duration getDuration(String key) throws StringValueConversionException {
        return this.getStringValue(key).toDuration();
    }

    @Override
    public final int getInt(String key) throws StringValueConversionException {
        return this.getStringValue(key).toInt();
    }

    @Override
    public final int getInt(String key, int defaultValue) throws StringValueConversionException {
        return this.getStringValue(key).toInt(defaultValue);
    }

    @Override
    public final long getLong(String key) throws StringValueConversionException {
        return this.getStringValue(key).toLong();
    }

    @Override
    public final long getLong(String key, long defaultValue) throws StringValueConversionException {
        return this.getStringValue(key).toLong(defaultValue);
    }

    @Override
    public final String getString(String key, String defaultValue) {
        String value = this.getString(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public final String getString(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray() && Array.getLength(o) > 0) {
            Object arrayValue = Array.get(o, 0);
            if (arrayValue == null) {
                return null;
            }
            return arrayValue.toString();
        }
        return o.toString();
    }

    @Override
    public final CharSequence getCharSequence(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray() && Array.getLength(o) > 0) {
            Object arrayValue = Array.get(o, 0);
            if (arrayValue == null) {
                return null;
            }
            if (arrayValue instanceof CharSequence) {
                return (CharSequence)arrayValue;
            }
            return arrayValue.toString();
        }
        if (o instanceof CharSequence) {
            return (CharSequence)o;
        }
        return o.toString();
    }

    @Override
    public String[] getStringArray(String key) {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            String[] array = new String[length];
            for (int i = 0; i < length; ++i) {
                Object arrayValue = Array.get(o, i);
                if (arrayValue == null) continue;
                array[i] = arrayValue.toString();
            }
            return array;
        }
        return new String[]{o.toString()};
    }

    @Override
    public StringValue getStringValue(String key) {
        return StringValue.valueOf(this.getString(key));
    }

    @Override
    public final Time getTime(String key) throws StringValueConversionException {
        return this.getStringValue(key).toTime();
    }

    @Override
    public final boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public final IValueMap makeImmutable() {
        this.immutable = true;
        return this;
    }

    @Override
    public Object put(String key, Object value) {
        this.checkMutability();
        return super.put(key, value);
    }

    public final Object add(String key, String value) {
        this.checkMutability();
        Object o = this.get(key);
        if (o == null) {
            return this.put(key, (Object)value);
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            String[] destArray = new String[length + 1];
            for (int i = 0; i < length; ++i) {
                Object arrayValue = Array.get(o, i);
                if (arrayValue == null) continue;
                destArray[i] = arrayValue.toString();
            }
            destArray[length] = value;
            return this.put(key, (Object)destArray);
        }
        return this.put(key, (Object)new String[]{o.toString(), value});
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.checkMutability();
        super.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        this.checkMutability();
        return super.remove(key);
    }

    @Override
    public String getKey(String key) {
        for (String keyValue : this.keySet()) {
            String keyString;
            if (!(keyValue instanceof String) || !key.equalsIgnoreCase(keyString = keyValue)) continue;
            return keyString;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : this.entrySet()) {
            if (!first) {
                buffer.append(' ');
            }
            first = false;
            buffer.append((String)entry.getKey());
            buffer.append(" = \"");
            Object value = entry.getValue();
            if (value == null) {
                buffer.append("null");
            } else if (value.getClass().isArray()) {
                buffer.append(Arrays.asList((Object[])value));
            } else {
                buffer.append(value);
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    private void checkMutability() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Map is immutable");
        }
    }

    @Override
    public Boolean getAsBoolean(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        try {
            return this.getBoolean(key);
        }
        catch (StringValueConversionException ignored) {
            return null;
        }
    }

    @Override
    public boolean getAsBoolean(String key, boolean defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        try {
            return this.getBoolean(key);
        }
        catch (StringValueConversionException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Integer getAsInteger(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        try {
            return this.getInt(key);
        }
        catch (StringValueConversionException ignored) {
            return null;
        }
    }

    @Override
    public int getAsInteger(String key, int defaultValue) {
        try {
            return this.getInt(key, defaultValue);
        }
        catch (StringValueConversionException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Long getAsLong(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        try {
            return this.getLong(key);
        }
        catch (StringValueConversionException ignored) {
            return null;
        }
    }

    @Override
    public long getAsLong(String key, long defaultValue) {
        try {
            return this.getLong(key, defaultValue);
        }
        catch (StringValueConversionException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Double getAsDouble(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        try {
            return this.getDouble(key);
        }
        catch (StringValueConversionException ignored) {
            return null;
        }
    }

    @Override
    public double getAsDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key, defaultValue);
        }
        catch (StringValueConversionException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Duration getAsDuration(String key) {
        return this.getAsDuration(key, null);
    }

    @Override
    public Duration getAsDuration(String key, Duration defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        try {
            return this.getDuration(key);
        }
        catch (StringValueConversionException ignored) {
            return defaultValue;
        }
    }

    @Override
    public Time getAsTime(String key) {
        return this.getAsTime(key, null);
    }

    @Override
    public Time getAsTime(String key, Time defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        try {
            return this.getTime(key);
        }
        catch (StringValueConversionException ignored) {
            return defaultValue;
        }
    }

    @Override
    public <T extends Enum<T>> T getAsEnum(String key, Class<T> eClass) {
        return this.getEnumImpl(key, eClass, null);
    }

    @Override
    public <T extends Enum<T>> T getAsEnum(String key, T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Default value cannot be null");
        }
        return this.getEnumImpl(key, defaultValue.getClass(), defaultValue);
    }

    @Override
    public <T extends Enum<T>> T getAsEnum(String key, Class<T> eClass, T defaultValue) {
        return this.getEnumImpl(key, eClass, defaultValue);
    }

    private <T extends Enum<T>> T getEnumImpl(String key, Class<?> eClass, T defaultValue) {
        if (eClass == null) {
            throw new IllegalArgumentException("eClass value cannot be null");
        }
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        Method valueOf = null;
        try {
            valueOf = eClass.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find method valueOf(String s) for " + eClass.getName(), e);
        }
        try {
            return (T)((Enum)valueOf.invoke(eClass, value));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke method valueOf(String s) on " + eClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                return defaultValue;
            }
            throw new RuntimeException(e);
        }
    }

    static {
        EMPTY_MAP.makeImmutable();
    }
}

