/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.wicket.util.time.Time;

public class Connections {
    private Connections() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time getLastModified(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            Time time;
            long milliseconds;
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)connection;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                try {
                    milliseconds = jarFileConnection.getLastModified();
                }
                finally {
                    Connections.close(jarFileConnection);
                }
            } else {
                milliseconds = connection.getLastModified();
            }
            if (milliseconds == 0L) {
                time = null;
                return time;
            }
            time = Time.millis(milliseconds);
            return time;
        }
        finally {
            Connections.close(connection);
        }
    }

    public static void closeQuietly(URLConnection connection) {
        try {
            Connections.close(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(URLConnection connection) throws IOException {
        if (connection == null) {
            return;
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        } else {
            connection.getInputStream().close();
        }
    }
}

