/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.visit;

import java.util.Collections;
import java.util.Iterator;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisitFilter;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visits {
    private Visits() {
    }

    public static final <S, R> R visit(Iterable<? super S> container, IVisitor<S, R> visitor) {
        return Visits.visitChildren(new SingletonIterable<Iterable<? super S>>(container), visitor, IVisitFilter.ANY);
    }

    public static final <S, R> R visit(Iterable<? super S> container, IVisitor<S, R> visitor, IVisitFilter filter) {
        return Visits.visitChildren(new SingletonIterable<Iterable<? super S>>(container), visitor, filter);
    }

    public static final <S, R> R visitChildren(Iterable<? super S> container, IVisitor<S, R> visitor, IVisitFilter filter) {
        Visit visit = new Visit();
        Visits.visitChildren(container, visitor, filter, visit);
        return visit.getResult();
    }

    private static final <S, R> void visitChildren(Iterable<? super S> container, IVisitor<S, R> visitor, IVisitFilter filter, Visit<R> visit) {
        Args.notNull(visitor, "visitor");
        for (S child : container) {
            if (filter.visitObject(child)) {
                Visit childTraversal = new Visit();
                S s = child;
                visitor.component(s, childTraversal);
                if (childTraversal.isStopped()) {
                    visit.stop(childTraversal.getResult());
                    return;
                }
                if (childTraversal.isDontGoDeeper()) continue;
            }
            if (visit.isDontGoDeeper() || !(child instanceof Iterable) || !filter.visitChildren(child)) continue;
            Visits.visitChildren((Iterable)child, visitor, filter, visit);
            if (!visit.isStopped()) continue;
            return;
        }
    }

    public static final <S, R> R visitChildren(Iterable<? super S> container, IVisitor<S, R> visitor) {
        return Visits.visitChildren(container, visitor, IVisitFilter.ANY);
    }

    public static final <S, R> R visitPostOrder(S root, IVisitor<S, R> visitor) {
        return Visits.visitPostOrder(root, visitor, IVisitFilter.ANY);
    }

    public static final <S, R> R visitPostOrder(Object root, IVisitor<S, R> visitor, IVisitFilter filter) {
        Args.notNull(visitor, "visitor");
        Visit visit = new Visit();
        Visits.visitPostOrderHelper(root, visitor, filter, visit);
        return visit.getResult();
    }

    private static final <S, R> void visitPostOrderHelper(Object component, IVisitor<S, R> visitor, IVisitFilter filter, Visit<R> visit) {
        Iterable container;
        if (component instanceof Iterable && filter.visitChildren(container = (Iterable)component)) {
            Visit childTraversal = new Visit();
            for (Object child : (Iterable)component) {
                Visits.visitPostOrderHelper(child, visitor, filter, childTraversal);
                if (!childTraversal.isStopped()) continue;
                visit.stop(childTraversal.getResult());
                return;
            }
        }
        if (filter.visitObject(component)) {
            visitor.component(component, visit);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterable<T>
    implements Iterable<T> {
        private final T singleton;

        public SingletonIterable(T singleton) {
            this.singleton = singleton;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singleton(this.singleton).iterator();
        }
    }
}

