/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractConverter;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractJavaTimeConverter<T extends Temporal>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;

    protected abstract T createTemporal(TemporalAccessor var1);

    @Override
    public T convertToObject(String value, Locale locale) {
        if (Strings.isEmpty(value)) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter(locale);
        TemporalAccessor temporalAccessor = dateTimeFormatter.parse(value);
        return this.createTemporal(temporalAccessor);
    }

    @Override
    public String convertToString(T value, Locale locale) {
        if (value == null) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter(locale);
        if (dateTimeFormatter != null) {
            return dateTimeFormatter.format((TemporalAccessor)value);
        }
        return value.toString();
    }

    public DateTimeFormatter getDateTimeFormatter(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return this.getDateTimeFormatter().withLocale(locale);
    }

    protected abstract DateTimeFormatter getDateTimeFormatter();
}

