/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.wink.common.http.HttpStatus;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.handlers.ResponseHandler;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadMethodHandler
implements RequestHandler,
ResponseHandler {
    private static final Logger logger = LoggerFactory.getLogger(HeadMethodHandler.class);
    private static final String ORIGINAL_RESPONSE_ATT_NAME = HeadMethodHandler.class.getName() + "_original_response";

    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        chain.doChain(context);
        SearchResult searchResult = (SearchResult)context.getAttribute(SearchResult.class);
        if (searchResult.isError() && searchResult.getError().getResponse().getStatus() == HttpStatus.METHOD_NOT_ALLOWED.getCode() && context.getHttpMethod().equalsIgnoreCase("HEAD")) {
            logger.trace("No HEAD method so trying GET method while not sending the response entity");
            context.setHttpMethod("GET");
            HttpServletResponse originalResponse = (HttpServletResponse)context.getAttribute(HttpServletResponse.class);
            NoBodyResponse noBodyResponse = new NoBodyResponse(originalResponse);
            context.setAttribute(HttpServletResponse.class, (Object)noBodyResponse);
            context.setAttribute(HttpServletResponseWrapper.class, (Object)noBodyResponse);
            context.setAttribute(NoBodyResponse.class, (Object)noBodyResponse);
            context.getAttributes().put(ORIGINAL_RESPONSE_ATT_NAME, originalResponse);
            chain.doChain(context);
        }
    }

    public void handleResponse(MessageContext context, HandlersChain chain) throws Throwable {
        HttpServletResponse originalResponse = (HttpServletResponse)context.getAttributes().remove(ORIGINAL_RESPONSE_ATT_NAME);
        if (originalResponse != null) {
            HttpServletResponse response = (HttpServletResponse)context.getAttribute(HttpServletResponse.class);
            response.flushBuffer();
            NoBodyResponse noBodyResponse = (NoBodyResponse)((Object)context.getAttribute(NoBodyResponse.class));
            response.setContentLength(noBodyResponse.getContentLengthValue());
            context.setAttribute(HttpServletResponse.class, originalResponse);
        }
        chain.doChain(context);
    }

    public void init(Properties props) {
    }

    private static final class NoBodyResponse
    extends HttpServletResponseWrapper {
        private PrintWriter writer = null;
        private CountingStream countingStream = null;

        NoBodyResponse(HttpServletResponse servletResponse) {
            super(servletResponse);
        }

        int getContentLengthValue() {
            return this.countingStream.getByteCount();
        }

        public void flushBuffer() {
            if (this.writer != null) {
                this.writer.flush();
            }
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                String charsetName = this.getCharacterEncoding() != null ? this.getCharacterEncoding() : "UTF-8";
                OutputStreamWriter osWriter = new OutputStreamWriter((OutputStream)this.getOutputStream(), charsetName);
                this.writer = new PrintWriter(osWriter);
            }
            return this.writer;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.countingStream == null) {
                this.countingStream = new CountingStream();
            }
            return this.countingStream;
        }

        private static final class CountingStream
        extends ServletOutputStream {
            private int byteCount = 0;

            private CountingStream() {
            }

            public int getByteCount() {
                return this.byteCount;
            }

            public void write(int b) throws IOException {
                ++this.byteCount;
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.byteCount += len;
            }
        }
    }
}

