/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Responses
implements ResponseHandler {
    private boolean isErrorFlow = false;
    private static final Logger logger = LoggerFactory.getLogger(Responses.class);
    private static final int BREAK_POINT = Integer.valueOf(System.getProperty(Responses.class.getName() + ".breakPoint", "4096"));
    private static final boolean IS_LOGGED_AS_BYTES = Boolean.valueOf(System.getProperty(Responses.class.getName() + ".logAsBytes", "false"));
    private static final int BUFFER_SIZE = Integer.valueOf(System.getProperty(Responses.class.getName() + ".bufferSize", "8192"));

    public void log() {
    }

    public void init(Properties props) {
    }

    public void setIsErrorFlow(boolean isErrorFlow) {
        this.isErrorFlow = isErrorFlow;
    }

    public boolean isErrorFlow() {
        return this.isErrorFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(MessageContext context, HandlersChain chain) throws Throwable {
        logger.trace("handleRequest({}, {}) entry", (Object)context, (Object)chain);
        try {
            if (logger.isDebugEnabled()) {
                this.logStartResponse(context);
            }
            chain.doChain(context);
        }
        finally {
            if (logger.isDebugEnabled()) {
                this.logFinishResponse(context);
            }
        }
        logger.trace("handleRequest({}, {}) exit", (Object)context, (Object)chain);
    }

    void logStartResponse(MessageContext context) {
        logger.trace("logStartResponse({}) entry", (Object)context);
        try {
            if (!logger.isDebugEnabled()) {
                logger.trace("logStartResponse() exit");
                return;
            }
            HttpServletResponseWrapper response = (HttpServletResponseWrapper)context.getAttribute(HttpServletResponseWrapper.class);
            if (response == null) {
                logger.debug("Could not find the HTTP Servlet Response to wrap.");
                logger.trace("logStartRequest() exit");
                return;
            }
            ResponseWrapper wrapper = new ResponseWrapper((HttpServletResponse)response);
            context.setAttribute(ResponseWrapper.class, (Object)wrapper);
            context.setAttribute(HttpServletResponse.class, (Object)wrapper);
            context.setAttribute(HttpServletResponseWrapper.class, (Object)wrapper);
        }
        catch (Exception e) {
            logger.trace("Could not log the start of the request", (Throwable)e);
        }
        logger.trace("logStartResponse() exit");
    }

    void logFinishResponse(MessageContext context) {
        logger.trace("logFinishResponse({}) entry", (Object)context);
        try {
            MultivaluedMap<String, String> headers;
            if (!logger.isDebugEnabled()) {
                logger.trace("logFinishResponse() exit");
                return;
            }
            ResponseWrapper responseWrapper = (ResponseWrapper)((Object)context.getAttribute(ResponseWrapper.class));
            if (responseWrapper == null) {
                logger.debug("Did not find the ResponseWrapper so will not log the response entity.");
                logger.trace("logStartRequest() exit");
                return;
            }
            if (this.isErrorFlow) {
                logger.debug("An error occurred when handling the initial request/response, so wrote the entity and headers in the error response handlers chain.");
            }
            if ((headers = responseWrapper.getLoggedResponseHeaders()) != null && headers.size() > 0) {
                ArrayList keys = new ArrayList(headers.keySet());
                Collections.sort(keys);
                StringBuilder sb = new StringBuilder();
                Formatter f = new Formatter(sb);
                for (String k : keys) {
                    List values = (List)headers.get((Object)k);
                    for (String v : values) {
                        f.format("%n%1$-30s%2$s", k, v);
                    }
                }
                logger.debug("The written response headers:{}", (Object)sb);
            } else {
                logger.debug("There were no custom headers written on the response.");
            }
            LoggedServletOutputStream loggedOutputStream = responseWrapper.getLoggedOutputStream();
            if (loggedOutputStream == null || loggedOutputStream.getLoggedByteBufferLength() == 0) {
                logger.debug("The response entity was not written to the HttpServletResponse.getOutputStream().");
                return;
            }
            byte[] buffer = loggedOutputStream.getLoggedByteBuffer();
            int bufferLength = loggedOutputStream.getLoggedByteBufferLength();
            if (IS_LOGGED_AS_BYTES) {
                logger.debug("The response entity as bytes:");
                StringBuffer sb = new StringBuffer();
                int outputCount = 0;
                for (int count = 0; count < bufferLength; ++count) {
                    sb.append(String.format("%#04x ", buffer[count]));
                    sb.append(" ");
                    if (++outputCount <= BREAK_POINT) continue;
                    logger.debug("{}", (Object)sb);
                    sb = new StringBuffer();
                    outputCount = 0;
                }
                if (outputCount > 0) {
                    logger.debug("{}", (Object)sb);
                    sb = new StringBuffer();
                }
            } else {
                int length;
                logger.debug("The response entity as a String in the default encoding:");
                for (int offset = 0; offset < bufferLength; offset += length) {
                    length = bufferLength - offset;
                    if (length > BREAK_POINT) {
                        length = BREAK_POINT;
                    }
                    String str = new String(buffer, offset, length);
                    logger.debug("{}", (Object)str);
                }
            }
            context.setAttribute(ResponseWrapper.class, null);
        }
        catch (Exception e) {
            logger.debug("Could not log the finishing of the response", (Throwable)e);
        }
        logger.trace("logFinishResponse() exit");
    }

    public static class LoggedServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream originalRequest;
        private final byte[] responseBuffer;
        private int offset = 0;

        public LoggedServletOutputStream(ServletOutputStream originalRequest, int bufferSize) {
            this.originalRequest = originalRequest;
            this.responseBuffer = new byte[bufferSize];
        }

        public void write(int b) throws IOException {
            if (this.offset < this.responseBuffer.length) {
                this.responseBuffer[this.offset] = (byte)b;
                ++this.offset;
            }
            this.originalRequest.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                int length = len;
                if (len + this.offset >= this.responseBuffer.length) {
                    length = this.responseBuffer.length - this.offset;
                }
                System.arraycopy(b, off, this.responseBuffer, this.offset, length);
                this.offset += length;
            }
            this.originalRequest.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            if (b.length > 0) {
                int length = b.length;
                if (b.length + this.offset >= this.responseBuffer.length) {
                    length = this.responseBuffer.length - this.offset;
                }
                System.arraycopy(b, 0, this.responseBuffer, this.offset, length);
                this.offset += length;
            }
            this.originalRequest.write(b);
        }

        public int getLoggedByteBufferLength() {
            return this.offset;
        }

        public byte[] getLoggedByteBuffer() {
            return this.responseBuffer;
        }

        public void close() throws IOException {
            this.originalRequest.close();
        }

        public void flush() throws IOException {
            this.originalRequest.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private final HttpServletResponse response;
        private LoggedServletOutputStream outputStreamLogger = null;
        private ServletOutputStream originalStream;
        private boolean hasStreamBeenRetrievedBefore = false;
        private MultivaluedMap<String, String> headers = new MultivaluedMapImpl();

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
            this.response = response;
        }

        public void addHeader(String headerName, String headerValue) {
            this.headers.add((Object)headerName, (Object)headerValue);
            super.addHeader(headerName, headerValue);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStreamLogger != null) {
                return this.outputStreamLogger;
            }
            if (!this.hasStreamBeenRetrievedBefore) {
                this.originalStream = this.response.getOutputStream();
            }
            if (this.originalStream == null) {
                logger.debug("The web container did not return a stream from HttpServletResponse.getOutputStream()");
                return null;
            }
            this.outputStreamLogger = new LoggedServletOutputStream(this.originalStream, BUFFER_SIZE);
            return this.outputStreamLogger;
        }

        public LoggedServletOutputStream getLoggedOutputStream() {
            return this.outputStreamLogger;
        }

        public MultivaluedMap<String, String> getLoggedResponseHeaders() {
            return this.headers;
        }
    }
}

