/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc.hive;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnUtil.class);
    private static YarnClient yarnClient;

    public static String getYarnAppIdByTag(String paragraphId) {
        if (yarnClient == null) {
            return null;
        }
        HashSet applicationTypes = Sets.newHashSet((Object[])new String[]{"MAPREDUCE", "TEZ"});
        EnumSet yarnStates = Sets.newEnumSet((Iterable)Lists.newArrayList((Object[])new YarnApplicationState[]{YarnApplicationState.RUNNING}), YarnApplicationState.class);
        try {
            List apps = yarnClient.getApplications((Set)applicationTypes, yarnStates);
            for (ApplicationReport appReport : apps) {
                if (!appReport.getApplicationTags().contains(paragraphId)) continue;
                return appReport.getApplicationId().toString();
            }
            return null;
        }
        catch (IOException | YarnException e) {
            LOGGER.warn("Fail to get yarn apps", e);
            return null;
        }
    }

    static {
        try {
            yarnClient = YarnClient.createYarnClient();
            YarnConfiguration yarnConf = new YarnConfiguration();
            yarnConf.set("yarn.timeline-service.enabled", "false");
            yarnClient.init((Configuration)yarnConf);
            yarnClient.start();
        }
        catch (Exception e) {
            LOGGER.warn("Fail to start yarnClient", (Throwable)e);
        }
    }
}

