/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc.security;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSecurityImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCSecurityImpl.class);

    public static void createSecureConfiguration(Properties properties, UserGroupInformation.AuthenticationMethod authType) {
        switch (authType) {
            case KERBEROS: {
                Configuration conf = new Configuration();
                conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
                UserGroupInformation.setConfiguration((Configuration)conf);
                try {
                    if (!UserGroupInformation.isSecurityEnabled() || UserGroupInformation.getCurrentUser().getAuthenticationMethod() != UserGroupInformation.AuthenticationMethod.KERBEROS || !UserGroupInformation.isLoginKeytabBased()) {
                        String keytab = properties.getProperty("zeppelin.jdbc.keytab.location");
                        String principal = properties.getProperty("zeppelin.jdbc.principal");
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                        LOGGER.info("Login successfully via keytab: {} and principal: {}", (Object)keytab, (Object)principal);
                        break;
                    }
                    UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
                    LOGGER.info("The user has already logged in using Keytab and principal, will check tgt and whether to re-login");
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to get either keytab location or principal name in the interpreter", (Throwable)e);
                }
            }
        }
    }

    public static UserGroupInformation.AuthenticationMethod getAuthType(Properties properties) {
        UserGroupInformation.AuthenticationMethod authType;
        try {
            authType = UserGroupInformation.AuthenticationMethod.valueOf((String)properties.getProperty("zeppelin.jdbc.auth.type").trim().toUpperCase());
        }
        catch (Exception e) {
            LOGGER.error(String.format("Invalid auth.type detected with value %s, defaulting auth.type to SIMPLE", properties.getProperty("zeppelin.jdbc.auth.type")));
            authType = UserGroupInformation.AuthenticationMethod.SIMPLE;
        }
        return authType;
    }
}

