/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cdi;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDIObjectFactory
implements AtmosphereObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(CDIObjectFactory.class);
    private BeanManager bm;

    public CDIObjectFactory() {
        try {
            this.bm = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
        }
        catch (NamingException ex) {
            try {
                this.bm = (BeanManager)new InitialContext().lookup("java:comp/env/BeanManager");
            }
            catch (NamingException e) {
                logger.error("{}", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, U extends T> U newClassInstance(AtmosphereFramework framework, Class<T> classType, Class<U> classToInstantiate) throws InstantiationException, IllegalAccessException {
        Object cc = null;
        try {
            Object dao;
            Iterator i = this.bm.getBeans(classToInstantiate, new Annotation[0]).iterator();
            if (!i.hasNext()) {
                logger.trace("Unable to find {}. Creating the object directly.", (Object)classToInstantiate.getName());
                U u = classToInstantiate.newInstance();
                return u;
            }
            Bean bean = (Bean)i.next();
            CreationalContext ctx = this.bm.createCreationalContext((Contextual)bean);
            Object object = dao = this.bm.getReference(bean, classToInstantiate, ctx);
            return (U)object;
        }
        catch (Exception e) {
            logger.error("Unable to construct {}. Creating the object directly.", (Object)classToInstantiate.getName());
            U u = classToInstantiate.newInstance();
            return u;
        }
        finally {
            if (cc != null) {
                cc.release();
            }
        }
    }

    public String toString() {
        return "CDI ObjectFactory";
    }
}

