/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertPathParameters;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLServerSocket;
import org.bouncycastle.jsse.provider.ProvX509ExtendedTrustManager;
import org.bouncycastle.jsse.provider.ProvX509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvTrustManagerFactorySpi
extends TrustManagerFactorySpi {
    static final boolean hasExtendedTrustManager;
    static final String CACERTS_PATH;
    static final String JSSECACERTS_PATH;
    protected final Provider pkixProvider;
    protected X509TrustManager trustManager;

    public ProvTrustManagerFactorySpi(Provider provider) {
        this.pkixProvider = provider;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.trustManager};
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        try {
            Object object;
            if (keyStore == null) {
                Object object2;
                keyStore = this.createTrustStore();
                object = null;
                char[] cArray = null;
                String string = PropertyUtils.getSystemProperty("javax.net.ssl.trustStore");
                if (string != null) {
                    if (new File(string).exists()) {
                        object = string;
                        object2 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStorePassword");
                        if (object2 != null) {
                            cArray = ((String)object2).toCharArray();
                        }
                    }
                } else if (new File(JSSECACERTS_PATH).exists()) {
                    object = JSSECACERTS_PATH;
                } else if (new File(CACERTS_PATH).exists()) {
                    object = CACERTS_PATH;
                }
                if (object == null) {
                    keyStore.load(null, null);
                } else {
                    object2 = new BufferedInputStream(new FileInputStream((String)object));
                    keyStore.load((InputStream)object2, cArray);
                    ((InputStream)object2).close();
                }
            }
            object = this.getTrustAnchors(keyStore);
            this.trustManager = hasExtendedTrustManager ? new ProvX509ExtendedTrustManager(new ProvX509TrustManager(this.pkixProvider, (Set)object)) : new ProvX509TrustManager(this.pkixProvider, (Set)object);
        }
        catch (Exception exception) {
            throw new KeyStoreException("initialization failed", exception);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof CertPathTrustManagerParameters) {
            try {
                CertPathParameters certPathParameters = ((CertPathTrustManagerParameters)managerFactoryParameters).getParameters();
                if (!(certPathParameters instanceof PKIXParameters)) {
                    throw new InvalidAlgorithmParameterException("parameters must inherit from PKIXParameters");
                }
                PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
                if (hasExtendedTrustManager) {
                    this.trustManager = new ProvX509ExtendedTrustManager(new ProvX509TrustManager(this.pkixProvider, pKIXParameters));
                }
                this.trustManager = new ProvX509TrustManager(this.pkixProvider, pKIXParameters);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidAlgorithmParameterException("unable to process parameters: " + generalSecurityException.getMessage(), generalSecurityException);
            }
        } else {
            if (managerFactoryParameters == null) {
                throw new InvalidAlgorithmParameterException("spec cannot be null");
            }
            throw new InvalidAlgorithmParameterException("unknown spec: " + managerFactoryParameters.getClass().getName());
        }
    }

    private String getTrustStoreType() {
        String string = PropertyUtils.getSystemProperty("javax.net.ssl.trustStoreType");
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        return string;
    }

    private KeyStore createTrustStore() throws NoSuchProviderException, KeyStoreException {
        String string = this.getTrustStoreType();
        String string2 = PropertyUtils.getSystemProperty("javax.net.ssl.trustStoreProvider");
        KeyStore keyStore = string2 == null || string2.length() < 1 ? KeyStore.getInstance(string) : KeyStore.getInstance(string, string2);
        return keyStore;
    }

    private Set<TrustAnchor> getTrustAnchors(KeyStore keyStore) throws KeyStoreException {
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>(keyStore.size());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            hashSet.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        return hashSet;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = ProvSSLServerSocket.class.getClassLoader().loadClass("javax.net.ssl.X509ExtendedTrustManager");
        }
        catch (Exception exception) {
            clazz = null;
        }
        hasExtendedTrustManager = clazz != null;
        String string = PropertyUtils.getSystemProperty("java.home");
        CACERTS_PATH = string + "/lib/security/cacerts".replace('/', File.separatorChar);
        JSSECACERTS_PATH = string + "/lib/security/jssecacerts".replace('/', File.separatorChar);
    }
}

