/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsDHDomain;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.tls.crypto.TlsECDomain;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;

public interface TlsCrypto {
    public boolean hasAllRawSignatureAlgorithms();

    public boolean hasDHAgreement();

    public boolean hasECDHAgreement();

    public boolean hasEncryptionAlgorithm(int var1);

    public boolean hasHashAlgorithm(short var1);

    public boolean hasMacAlgorithm(int var1);

    public boolean hasNamedCurve(int var1);

    public boolean hasRSAEncryption();

    public boolean hasSignatureAlgorithm(int var1);

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm var1);

    public boolean hasSRPAuthentication();

    public TlsSecret createSecret(byte[] var1);

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion var1);

    public SecureRandom getSecureRandom();

    public TlsCertificate createCertificate(byte[] var1) throws IOException;

    public TlsDHDomain createDHDomain(TlsDHConfig var1);

    public TlsECDomain createECDomain(TlsECConfig var1);

    public TlsSecret adoptSecret(TlsSecret var1);

    public TlsHash createHash(SignatureAndHashAlgorithm var1);

    public TlsHash createHash(short var1);

    public TlsHMAC createHMAC(int var1) throws IOException;

    public byte[] createNonce(int var1);

    public TlsSRP6Client createSRP6Client(TlsSRPConfig var1);

    public TlsSRP6Server createSRP6Server(TlsSRPConfig var1, BigInteger var2);

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig var1);
}

