/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;

public class BcTlsDH
implements TlsAgreement {
    protected BcTlsDHDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected DHPublicKeyParameters peerPublicKey;

    public BcTlsDH(BcTlsDHDomain bcTlsDHDomain) {
        this.domain = bcTlsDHDomain;
    }

    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((DHPublicKeyParameters)this.localKeyPair.getPublic());
    }

    public void receivePeerValue(byte[] byArray) throws IOException {
        DHPublicKeyParameters dHPublicKeyParameters = this.domain.decodePublicKey(byArray);
        TlsDHUtils.validateDHPublicValues(dHPublicKeyParameters.getY(), dHPublicKeyParameters.getParameters().getP());
        this.peerPublicKey = dHPublicKeyParameters;
    }

    public TlsSecret calculateSecret() throws IOException {
        byte[] byArray = this.domain.calculateDHAgreement(this.peerPublicKey, (DHPrivateKeyParameters)this.localKeyPair.getPrivate());
        return this.domain.getCrypto().adoptLocalSecret(byArray);
    }
}

