/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Arrays;

public class BcTlsSecret
extends AbstractTlsSecret {
    protected final BcTlsCrypto crypto;

    public BcTlsSecret(BcTlsCrypto bcTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = bcTlsCrypto;
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    public synchronized TlsSecret deriveSSLKeyBlock(byte[] byArray, int n) {
        this.checkAlive();
        int n2 = (n + 16 - 1) / 16;
        byte[] byArray2 = this.prf_SSL(byArray, n2);
        BcTlsSecret bcTlsSecret = this.crypto.adoptLocalSecret(Arrays.copyOfRange((byte[])byArray2, (int)0, (int)n));
        Arrays.fill((byte[])byArray2, (byte)0);
        return bcTlsSecret;
    }

    public synchronized TlsSecret deriveSSLMasterSecret(byte[] byArray) {
        this.checkAlive();
        return this.crypto.adoptLocalSecret(this.prf_SSL(byArray, 3));
    }

    public synchronized TlsSecret deriveUsingPRF(int n, byte[] byArray, int n2) {
        this.checkAlive();
        byte[] byArray2 = n == 0 ? this.prf_1_0(this.data, byArray, n2) : this.prf_1_2(this.crypto.createPRFHash(n), this.data, byArray, n2);
        return this.crypto.adoptLocalSecret(byArray2);
    }

    protected void hmacHash(Digest digest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        HMac hMac = new HMac(digest);
        hMac.init((CipherParameters)new KeyParameter(byArray));
        byte[] byArray4 = byArray2;
        int n = digest.getDigestSize();
        int n2 = (byArray3.length + n - 1) / n;
        byte[] byArray5 = new byte[hMac.getMacSize()];
        byte[] byArray6 = new byte[hMac.getMacSize()];
        for (int i = 0; i < n2; ++i) {
            hMac.update(byArray4, 0, byArray4.length);
            hMac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            hMac.update(byArray4, 0, byArray4.length);
            hMac.update(byArray2, 0, byArray2.length);
            hMac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n * i, Math.min(n, byArray3.length - n * i));
        }
    }

    protected byte[] prf_SSL(byte[] byArray, int n) {
        Digest digest = BcTlsCrypto.createDigest((short)1);
        Digest digest2 = BcTlsCrypto.createDigest((short)2);
        int n2 = digest.getDigestSize();
        byte[] byArray2 = new byte[n2 * n];
        int n3 = 0;
        byte[] byArray3 = new byte[digest2.getDigestSize()];
        for (int i = 0; i < n; ++i) {
            byte[] byArray4 = SSL3_CONST[i];
            digest2.update(byArray4, 0, byArray4.length);
            digest2.update(this.data, 0, this.data.length);
            digest2.update(byArray, 0, byArray.length);
            digest2.doFinal(byArray3, 0);
            digest.update(this.data, 0, this.data.length);
            digest.update(byArray3, 0, byArray3.length);
            digest.doFinal(byArray2, n3);
            n3 += n2;
        }
        return byArray2;
    }

    protected byte[] prf_1_0(byte[] byArray, byte[] byArray2, int n) {
        int n2 = (byArray.length + 1) / 2;
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray, byArray.length - n2, byArray4, 0, n2);
        byte[] byArray5 = new byte[n];
        byte[] byArray6 = new byte[n];
        this.hmacHash(BcTlsCrypto.createDigest((short)1), byArray3, byArray2, byArray5);
        this.hmacHash(BcTlsCrypto.createDigest((short)2), byArray4, byArray2, byArray6);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray5[n3] = (byte)(byArray5[n3] ^ byArray6[i]);
        }
        return byArray5;
    }

    protected byte[] prf_1_2(Digest digest, byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[n];
        this.hmacHash(digest, byArray, byArray2, byArray3);
        return byArray3;
    }
}

