/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected Hashtable clientAgreements = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.tlsClientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        this.tlsClient.init(this.tlsClientContext);
        this.recordStream.init(this.tlsClientContext);
        tlsClient.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    protected void beginHandshake(boolean bl) throws IOException {
        SessionParameters sessionParameters;
        super.beginHandshake(bl);
        TlsSession tlsSession = this.tlsClient.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (sessionParameters = tlsSession.exportSessionParameters()) != null && sessionParameters.isExtendedMasterSecret()) {
            this.tlsSession = tlsSession;
            this.sessionParameters = sessionParameters;
        }
        this.sendClientHelloMessage();
        this.connection_state = 1;
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handleHandshakeMessage(short s, ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (this.resumedSession) {
            if (s != 20 || this.connection_state != 2) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(byteArrayInputStream);
            this.connection_state = (short)15;
            this.sendChangeCipherSpecMessage();
            this.sendFinishedMessage();
            this.connection_state = (short)13;
            this.completeHandshake();
            return;
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        TlsUtils.receiveServerCertificate(this.tlsClientContext, byteArrayInputStream);
                        this.authentication = this.tlsClient.getAuthentication();
                        if (null != this.authentication) break;
                        throw new TlsFatalAlert(80);
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)4;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 4: {
                        if (!this.allowCertificateStatus) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(byteArrayInputStream);
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 13: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 14: {
                        this.processFinishedMessage(byteArrayInputStream);
                        this.connection_state = (short)15;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        this.receiveServerHelloMessage(byteArrayInputStream);
                        this.connection_state = (short)2;
                        this.recordStream.notifyHelloComplete();
                        this.applyMaxFragmentLengthExtension();
                        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
                        if (this.resumedSession) {
                            securityParameters.masterSecret = this.tlsClientContext.getCrypto().adoptSecret(this.sessionParameters.getMasterSecret());
                            this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.getContext()));
                            break block0;
                        }
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                        this.sessionParameters = null;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 23: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(byteArrayInputStream));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: 
                    case 7: {
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        this.connection_state = (short)8;
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                        }
                        this.connection_state = (short)9;
                        TlsCredentials tlsCredentials = null;
                        TlsCredentialedSigner tlsCredentialedSigner = null;
                        TlsStreamSigner tlsStreamSigner = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            Certificate certificate = null;
                            tlsCredentials = TlsClientProtocol.validateCredentials(this.authentication.getClientCredentials(this.certificateRequest));
                            if (null == tlsCredentials) {
                                this.keyExchange.skipClientCredentials();
                            } else {
                                this.keyExchange.processClientCredentials(tlsCredentials);
                                certificate = tlsCredentials.getCertificate();
                                if (tlsCredentials instanceof TlsCredentialedSigner) {
                                    tlsCredentialedSigner = (TlsCredentialedSigner)tlsCredentials;
                                    tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
                                }
                            }
                            this.sendCertificateMessage(certificate, null);
                        }
                        this.connection_state = (short)10;
                        boolean bl = tlsStreamSigner != null;
                        TlsUtils.sealHandshakeHash(this.getContext(), this.recordStream.getHandshakeHash(), bl);
                        this.sendClientKeyExchangeMessage();
                        this.connection_state = (short)11;
                        TlsHandshakeHash tlsHandshakeHash = this.recordStream.prepareToFinish();
                        this.tlsClientContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(tlsHandshakeHash);
                        TlsClientProtocol.establishMasterSecret(this.getContext(), this.keyExchange);
                        this.recordStream.setPendingConnectionState(TlsUtils.initCipher(this.getContext()));
                        if (tlsCredentialedSigner != null) {
                            DigitallySigned digitallySigned = TlsUtils.generateCertificateVerify(this.getContext(), tlsCredentialedSigner, tlsStreamSigner, tlsHandshakeHash);
                            this.sendCertificateVerifyMessage(digitallySigned);
                            this.connection_state = (short)12;
                        }
                        this.sendChangeCipherSpecMessage();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)13;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.handleSupplementalData(null);
                    }
                    case 3: {
                        this.authentication = null;
                    }
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(byteArrayInputStream);
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)6;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 4: 
                    case 5: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 6: {
                        if (this.authentication == null) {
                            throw new TlsFatalAlert(40);
                        }
                        this.certificateRequest = CertificateRequest.parse(this.getContext(), byteArrayInputStream);
                        TlsClientProtocol.assertEmpty(byteArrayInputStream);
                        this.certificateRequest = TlsUtils.validateCertificateRequest(this.certificateRequest, this.keyExchange);
                        TlsUtils.trackHashAlgorithms(this.recordStream.getHandshakeHash(), this.certificateRequest.getSupportedSignatureAlgorithms());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 13: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicketMessage(byteArrayInputStream);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)14;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(byteArrayInputStream);
                if (this.connection_state != 16) break;
                this.handleRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.processServerCertificate(this.tlsClientContext, this.tlsClient, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector vector) throws IOException {
        this.tlsClient.processServerSupplementalData(vector);
        this.connection_state = (short)3;
        this.keyExchange = TlsUtils.initKeyExchangeClient(this.tlsClientContext, this.tlsClient);
    }

    protected void receiveNewSessionTicketMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected void receiveServerHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream, 0, 32);
        int n = TlsUtils.readUint16(byteArrayInputStream);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        this.serverExtensions = TlsClientProtocol.readExtensions(byteArrayInputStream);
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion.equals(this.tlsClientContext.getServerVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion)) {
                throw new TlsFatalAlert(47);
            }
            if (!ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(70);
            }
            object3 = protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : protocolVersion;
            this.recordStream.setWriteVersion((ProtocolVersion)object3);
            securityParameters.negotiatedVersion = protocolVersion;
        }
        this.tlsClient.notifyServerVersion(protocolVersion);
        if (!this.tlsClientContext.getClientVersion().equals(protocolVersion)) {
            TlsUtils.checkDowngradeMarker(protocolVersion, byArray);
        }
        securityParameters.serverRandom = byArray;
        securityParameters.sessionID = byArray2;
        this.tlsClient.notifySessionID(byArray2);
        boolean bl = this.resumedSession = byArray2.length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])byArray2, (byte[])this.tlsSession.getSessionID());
        if (!Arrays.contains((int[])this.offeredCipherSuites, (int)n) || n == 0 || CipherSuite.isSCSV(n) || !TlsUtils.isValidCipherSuiteForVersion(n, this.tlsClientContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.cipherSuite = n;
        this.tlsClient.notifySelectedCipherSuite(n);
        if (0 != s) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.serverExtensions);
        if (!securityParameters.isExtendedMasterSecret() && (this.resumedSession || this.tlsClient.requiresExtendedMasterSecret())) {
            throw new TlsFatalAlert(40);
        }
        if (this.serverExtensions != null) {
            object3 = this.serverExtensions.keys();
            while (object3.hasMoreElements()) {
                object2 = (Integer)object3.nextElement();
                if (((Integer)object2).equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, (Integer)object2)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        object3 = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (object3 == null) {
                throw new TlsFatalAlert(40);
            }
            object2 = this.tlsClientContext.getSecurityParametersConnection();
            object = TlsUtils.concat(((SecurityParameters)object2).getLocalVerifyData(), ((SecurityParameters)object2).getPeerVerifyData());
            if (!Arrays.constantTimeAreEqual((byte[])object3, (byte[])TlsClientProtocol.createRenegotiationInfo(object))) {
                throw new TlsFatalAlert(40);
            }
        } else if (object3 == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])object3, (byte[])TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        object2 = this.clientExtensions;
        object = this.serverExtensions;
        if (this.resumedSession) {
            if (securityParameters.getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !protocolVersion.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            object2 = null;
            object = this.sessionParameters.readServerExtensions();
        }
        if (object != null && !object.isEmpty()) {
            boolean bl2 = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)object);
            if (bl2 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl2;
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension((Hashtable)object2, (Hashtable)object, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)object);
            this.allowCertificateStatus = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl3 = this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)object, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object2 != null) {
            this.tlsClient.processServerExtensions((Hashtable)object);
        }
        securityParameters.prfAlgorithm = TlsClientProtocol.getPRFAlgorithm(this.tlsClientContext, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void sendCertificateVerifyMessage(DigitallySigned digitallySigned) throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(this, 15);
        digitallySigned.encode(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendClientHelloMessage() throws IOException {
        Object object;
        ProtocolVersion protocolVersion;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            protocolVersion = this.tlsClientContext.getClientVersion();
        } else {
            this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
            this.tlsClientContext.setClientSupportedVersions(this.tlsClient.getProtocolVersions());
            protocolVersion = ProtocolVersion.getLatestTLS(this.tlsClientContext.getClientSupportedVersions());
            if (null == protocolVersion || protocolVersion.isEarlierVersionOf(ProtocolVersion.TLSv10) || protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12)) {
                throw new TlsFatalAlert(80);
            }
            this.tlsClientContext.setClientVersion(protocolVersion);
        }
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (this.tlsSession != null && ((byArray = this.tlsSession.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        boolean bl = this.tlsClient.isFallback();
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        if (!(byArray.length <= 0 || this.sessionParameters == null || this.sessionParameters.isExtendedMasterSecret() && Arrays.contains((int[])this.offeredCipherSuites, (int)this.sessionParameters.getCipherSuite()) && 0 == this.sessionParameters.getCompressionAlgorithm())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12)) {
            protocolVersion2 = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(this.clientExtensions, this.tlsClientContext.getClientSupportedVersions());
        }
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            securityParameters.clientSigAlgs = TlsExtensionsUtils.getSignatureAlgorithmsExtension(this.clientExtensions);
            securityParameters.clientSigAlgsCert = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(this.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
        this.clientAgreements = TlsUtils.addEarlyKeySharesToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions);
        TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(this.tlsClient.shouldUseGMTUnixTime(), this.tlsClientContext);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            object = this.tlsClientContext.getSecurityParametersConnection();
            this.clientExtensions.put(EXT_RenegotiationInfo, TlsClientProtocol.createRenegotiationInfo(((SecurityParameters)object).getLocalVerifyData()));
        } else {
            boolean bl2;
            boolean bl3 = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
            boolean bl4 = bl2 = !Arrays.contains((int[])this.offeredCipherSuites, (int)255);
            if (bl3 && bl2) {
                this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)255);
            }
        }
        if (bl && !Arrays.contains((int[])this.offeredCipherSuites, (int)22016)) {
            this.offeredCipherSuites = Arrays.append((int[])this.offeredCipherSuites, (int)22016);
        }
        object = new ClientHello(protocolVersion2, securityParameters.getClientRandom(), byArray, null, this.offeredCipherSuites, this.clientExtensions);
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(this, 1);
        ((ClientHello)object).encode(this.tlsClientContext, handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }

    protected void sendClientKeyExchangeMessage() throws IOException {
        TlsProtocol.HandshakeMessage handshakeMessage = new TlsProtocol.HandshakeMessage(this, 16);
        this.keyExchange.generateClientKeyExchange(handshakeMessage);
        handshakeMessage.writeToRecordStream();
    }
}

