/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.quartz;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.chenillekit.quartz.services.JobSchedulingBundle;
import org.chenillekit.quartz.services.QuartzSchedulerManager;
import org.chenillekit.quartz.services.impl.QuartzSchedulerManagerImpl;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChenilleKitQuartzModule {
    public SchedulerFactory buildSchedulerFactory(Logger logger, RegistryShutdownHub shutdownHub, List<URL> contributions) {
        if (logger.isInfoEnabled()) {
            logger.info("initialize scheduler factory");
        }
        try {
            if (contributions.isEmpty()) {
                throw new RuntimeException("Configuration to SchedulerFactory services needed");
            }
            Properties prop = new Properties();
            for (URL contibutionURL : contributions) {
                prop.load(contibutionURL.openStream());
            }
            StdSchedulerFactory factory = new StdSchedulerFactory(prop);
            shutdownHub.addRegistryShutdownListener(new Runnable((SchedulerFactory)factory){
                final /* synthetic */ SchedulerFactory val$factory;
                {
                    this.val$factory = schedulerFactory;
                }

                public void run() {
                    try {
                        List schedulers = CollectionFactory.newList((Collection)this.val$factory.getAllSchedulers());
                        for (Scheduler scheduler : schedulers) {
                            scheduler.shutdown();
                        }
                    }
                    catch (SchedulerException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return factory;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (SchedulerException se) {
            throw new RuntimeException(se);
        }
    }

    @EagerLoad
    public QuartzSchedulerManager buildQuartzSchedulerManager(Logger logger, SchedulerFactory schedulerFactory, List<JobSchedulingBundle> jobSchedulingBundles) {
        return new QuartzSchedulerManagerImpl(logger, schedulerFactory, jobSchedulingBundles);
    }
}

