/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.quartz.services.impl;

import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.chenillekit.quartz.services.JobSchedulingBundle;
import org.chenillekit.quartz.services.QuartzSchedulerManager;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzSchedulerManagerImpl
implements QuartzSchedulerManager {
    private final SchedulerFactory schedulerFactory;
    private final Logger logger;

    public QuartzSchedulerManagerImpl(Logger logger, SchedulerFactory schedulerFactory, Collection<JobSchedulingBundle> jobSchedulingBundles) {
        this.logger = logger;
        this.schedulerFactory = schedulerFactory;
        try {
            for (JobSchedulingBundle jobSchedulingBundle : jobSchedulingBundles) {
                this.addBundleToScheduler(jobSchedulingBundle);
            }
            List schedulers = CollectionFactory.newList((Collection)this.schedulerFactory.getAllSchedulers());
            for (Scheduler scheduler : schedulers) {
                scheduler.start();
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.getScheduler(null);
    }

    @Override
    public Scheduler getScheduler(String schedulerId) {
        try {
            Scheduler scheduler = schedulerId == null || schedulerId.length() == 0 ? this.schedulerFactory.getScheduler() : this.schedulerFactory.getScheduler(schedulerId);
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        try {
            List schedulers = CollectionFactory.newList((Collection)this.schedulerFactory.getAllSchedulers());
            for (Scheduler scheduler : schedulers) {
                this.shutdown(scheduler.getSchedulerName());
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown(String schedulerId) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler(schedulerId);
            scheduler.shutdown();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    private void addBundleToScheduler(JobSchedulingBundle jobSchedulingBundle) throws SchedulerException {
        JobDetail jobDetail = jobSchedulingBundle.getJobDetail();
        Trigger trigger = jobSchedulingBundle.getTrigger();
        String schedulerId = jobSchedulingBundle.getSchedulerId();
        Scheduler scheduler = this.getScheduler(schedulerId);
        if (schedulerId == null || schedulerId.length() == 0) {
            schedulerId = "default";
        }
        if (trigger != null) {
            if (this.logger.isInfoEnabled()) {
                String triggerName = trigger.getName();
                if (trigger instanceof CronTrigger) {
                    triggerName = triggerName + " (" + ((CronTrigger)trigger).getCronExpression() + ")";
                }
                this.logger.info("schedule job '{}' with trigger '{}' to scheduler '{}'", new Object[]{jobDetail.getName(), triggerName, schedulerId});
            }
            scheduler.scheduleJob(jobDetail, trigger);
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("add job '{}' to scheduler '{}'", (Object)jobDetail.getName(), (Object)schedulerId);
            }
            scheduler.addJob(jobDetail, true);
        }
    }
}

