/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit;

import java.lang.annotation.Annotation;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.junit.CitrusFrameworkMethod;

public final class JUnit4ParameterHelper {
    private JUnit4ParameterHelper() {
    }

    public static Object resolveAnnotatedResource(CitrusFrameworkMethod frameworkMethod, Class<?> parameterType, TestContext context) {
        Object storedBuilder = frameworkMethod.getAttribute("builder");
        if (TestCaseRunner.class.isAssignableFrom(parameterType)) {
            return storedBuilder;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof TestActionRunner) {
            return storedBuilder;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof GherkinTestActionRunner) {
            return storedBuilder;
        }
        if (TestContext.class.isAssignableFrom(parameterType)) {
            return context;
        }
        throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + parameterType);
    }

    public static Object[] resolveParameter(CitrusFrameworkMethod frameworkMethod, TestContext context) {
        Object[] values = new Object[frameworkMethod.getMethod().getParameterTypes().length];
        Class<?>[] parameterTypes = frameworkMethod.getMethod().getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations = frameworkMethod.getMethod().getParameterAnnotations()[i];
            Class<?> parameterType = parameterTypes[i];
            for (Annotation annotation : parameterAnnotations) {
                if (!(annotation instanceof CitrusResource)) continue;
                values[i] = JUnit4ParameterHelper.resolveAnnotatedResource(frameworkMethod, parameterType, context);
            }
        }
        return values;
    }
}

