/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.json.JsonPathUtils;

public class JsonPathFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        String jsonPathExpression;
        String jsonSource;
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        if (parameterList.size() < 2) {
            throw new InvalidFunctionUsageException("Missing parameter for function - usage jsonPath('jsonSource', 'expression')");
        }
        if (parameterList.size() > 2) {
            StringBuilder sb = new StringBuilder();
            sb.append(parameterList.get(0));
            for (int i = 1; i < parameterList.size() - 1; ++i) {
                sb.append(", ").append(parameterList.get(i));
            }
            jsonSource = sb.toString();
            jsonPathExpression = parameterList.get(parameterList.size() - 1);
        } else {
            jsonSource = parameterList.get(0);
            jsonPathExpression = parameterList.get(1);
        }
        return JsonPathUtils.evaluateAsString(context.replaceDynamicContentInString(jsonSource), jsonPathExpression);
    }
}

