/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements;

import java.io.InputStream;
import java.time.LocalDate;
import java.util.Optional;
import java.util.Properties;
import org.cp.elements.io.IOUtils;
import org.cp.elements.lang.StringUtils;

public class ElementsVersion
implements Runnable {
    public static final int DEFAULT_YEAR = 2011;
    protected static final String MAVEN_PROPERTIES_FILE_LOCATION = "META-INF/maven/org.codeprimate/cp-elements/pom.properties";
    protected static final String MAVEN_ARTIFACT_ID_PROPERTY = "artifactId";
    protected static final String MAVEN_GROUP_ID_PROPERTY = "groupId";
    protected static final String MAVEN_VERSION_PROPERTY = "version";
    public static final String PROJECT_ARTIFACT_ID = "cp-elements";
    public static final String PROJECT_LICENSE = "Apache License, version 2.0";
    public static final String PROJECT_NAME = "Codeprimate Elements";
    public static final String PROJECT_VERSION = "version 1.0.0.M4";
    private Properties maven;

    public static void main(String[] args) {
        new ElementsVersion().run();
    }

    @Override
    public void run() {
        this.log("%1$s (%2$s) %3$s - Copyright \u00a9 %4$d%n%5$s%n", PROJECT_NAME, this.resolveProjectArtifactId(), this.resolveProjectVersion(), this.resolveYear(), PROJECT_LICENSE);
    }

    private Properties loadMavenProperties() {
        Properties maven = new Properties();
        Optional.ofNullable(ElementsVersion.class.getResourceAsStream(MAVEN_PROPERTIES_FILE_LOCATION)).ifPresent(inputStream -> IOUtils.doSafeIo(() -> maven.load((InputStream)inputStream)));
        return maven;
    }

    private void log(String message, Object ... args) {
        System.err.printf(message, args);
        System.err.flush();
    }

    private Properties resolveMavenProperties() {
        return Optional.ofNullable(this.maven).orElseGet(() -> {
            this.maven = this.loadMavenProperties();
            return this.maven;
        });
    }

    private String resolveProjectArtifactId() {
        return this.resolveProjectArtifactId(PROJECT_ARTIFACT_ID);
    }

    private String resolveProjectArtifactId(String defaultArtifactId) {
        return Optional.ofNullable(this.resolveMavenProperties().getProperty(MAVEN_ARTIFACT_ID_PROPERTY)).filter(StringUtils::hasText).orElse(defaultArtifactId);
    }

    private String resolveProjectVersion() {
        return this.resolveProjectVersion(PROJECT_VERSION);
    }

    private String resolveProjectVersion(String defaultVersion) {
        return Optional.ofNullable(this.resolveMavenProperties().getProperty(MAVEN_VERSION_PROPERTY)).filter(StringUtils::hasText).orElse(defaultVersion);
    }

    private int resolveYear() {
        return this.resolveYear(2011);
    }

    private int resolveYear(int defaultYear) {
        return LocalDate.now().getYear();
    }
}

