/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.TreeMap;
import org.cp.elements.beans.Bean;
import org.cp.elements.beans.IllegalPropertyValueException;
import org.cp.elements.beans.PropertyNotFoundException;
import org.cp.elements.beans.event.ChangeListener;
import org.cp.elements.beans.event.ChangeSupport;
import org.cp.elements.beans.event.ChangeTracker;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.Visitor;
import org.cp.elements.util.ComparatorUtils;

public abstract class AbstractBean<ID extends Comparable<ID>, USER, PROCESS>
implements Bean<ID, USER, PROCESS> {
    private static final boolean DEFAULT_EVENT_DISPATCH_ENABLED = true;
    private volatile boolean eventDispatchEnabled = true;
    private final ChangeSupport changeSupport = new ChangeSupport(this);
    private final ChangeTracker changeTracker = new ChangeTracker();
    private ID id;
    private LocalDateTime createdOn;
    private LocalDateTime lastModifiedOn;
    private LocalDateTime modifiedOn;
    private final Map<String, String> propertyNameToFieldNameMapping = new TreeMap<String, String>();
    private final Map<String, ParameterizedStateChangeCallback> propertyNameToParameterizedStateChangeCallbackMapping = new TreeMap<String, ParameterizedStateChangeCallback>();
    private PROCESS createdWith;
    private PROCESS lastModifiedWith;
    private PROCESS modifiedWith;
    private final transient PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private USER createdBy;
    private USER lastModifiedBy;
    private USER modifiedBy;
    private final VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);

    public AbstractBean() {
        this.addPropertyChangeListener(this.changeTracker);
    }

    public AbstractBean(ID id) {
        this();
        this.id = id;
    }

    @Override
    public USER getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(USER createdBy) {
        this.processChange("createdBy", this.createdBy, createdBy);
    }

    @Override
    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Override
    public void setCreatedOn(LocalDateTime createdOn) {
        this.processChange("createdOn", this.createdOn, createdOn);
    }

    @Override
    public PROCESS getCreatedWith() {
        return this.createdWith;
    }

    @Override
    public void setCreatedWith(PROCESS creatingProcess) {
        this.processChange("createdWith", this.createdWith, creatingProcess);
    }

    public boolean isEventDispatchEnabled() {
        return this.eventDispatchEnabled;
    }

    protected final void setEventDispatchEnabled(boolean eventDispatchEnabled) {
        this.eventDispatchEnabled = eventDispatchEnabled;
    }

    protected String getFieldName(String propertyName) {
        return ObjectUtils.defaultIfNull(this.propertyNameToFieldNameMapping.get(propertyName), propertyName);
    }

    @Override
    public ID getId() {
        return this.id;
    }

    @Override
    public final void setId(ID id) {
        this.processChange("id", this.id, id);
    }

    @Override
    public USER getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Override
    public LocalDateTime getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    @Override
    public PROCESS getLastModifiedWith() {
        return this.lastModifiedWith;
    }

    @Override
    public boolean isModified() {
        return this.changeTracker.isModified();
    }

    @Override
    public boolean isModified(String propertyName) {
        return this.changeTracker.isModified(propertyName);
    }

    @Override
    public USER getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(USER modifiedBy) {
        this.processChange("modifiedBy", this.modifiedBy, modifiedBy);
        this.lastModifiedBy = ObjectUtils.defaultIfNull(this.lastModifiedBy, this.modifiedBy);
    }

    @Override
    public LocalDateTime getModifiedOn() {
        return this.modifiedOn;
    }

    @Override
    public void setModifiedOn(LocalDateTime modifiedOn) {
        this.processChange("modifiedOn", this.modifiedOn, modifiedOn);
        this.lastModifiedOn = ObjectUtils.defaultIfNull(this.lastModifiedOn, this.modifiedOn);
    }

    @Override
    public PROCESS getModifiedWith() {
        return this.modifiedWith;
    }

    @Override
    public void setModifiedWith(PROCESS modifyingProcess) {
        this.processChange("modifiedWith", this.modifiedWith, modifyingProcess);
        this.lastModifiedWith = ObjectUtils.defaultIfNull(this.lastModifiedWith, this.modifiedWith);
    }

    @Override
    public boolean isNew() {
        return this.getId() == null;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    protected void addChangeListener(ChangeListener listener) {
        this.changeSupport.add(listener);
    }

    protected void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    protected void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(propertyName, listener);
    }

    void changeState(String propertyName, Object newValue) {
        try {
            ObjectUtils.setField((Object)this, this.getFieldName(propertyName), newValue);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyNotFoundException(String.format("The property (%1$s) corresponding to field (%2$s) was not found in this Bean (%3$s)!", propertyName, this.getFieldName(propertyName), this.getClass().getName()), e);
        }
    }

    @Override
    public int compareTo(Bean<ID, USER, PROCESS> obj) {
        Assert.isInstanceOf(obj, this.getClass(), new ClassCastException(String.format("The Bean being compared with this Bean must be an instance of %1$s!", this.getClass().getName())));
        return ComparatorUtils.compareIgnoreNull(this.getId(), obj.getId());
    }

    protected PropertyChangeEvent newPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.isEventDispatchEnabled() && (this.vetoableChangeSupport.hasListeners(propertyName) || this.propertyChangeSupport.hasListeners(propertyName))) {
            return new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        }
        return this.propertyChangeEvent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Bean)) {
            return false;
        }
        Bean that = (Bean)obj;
        return ObjectUtils.equals(this.getId(), that.getId());
    }

    protected void fireChange() {
        if (this.isEventDispatchEnabled() && this.isModified() && this.changeSupport.hasListeners()) {
            this.changeSupport.fireChangeEvent();
        }
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        if (this.isEventDispatchEnabled()) {
            Assert.notNull(event, "The PropertyChangeEvent cannot be null!", new Object[0]);
            if (this.propertyChangeSupport.hasListeners(event.getPropertyName())) {
                this.propertyChangeSupport.firePropertyChange(event);
            }
        }
    }

    protected void fireVetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        if (this.isEventDispatchEnabled()) {
            Assert.notNull(event, "The PropertyChangeEvent cannot be null!", new Object[0]);
            if (this.vetoableChangeSupport.hasListeners(event.getPropertyName())) {
                this.vetoableChangeSupport.fireVetoableChange(event);
            }
        }
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getId());
        return hashValue;
    }

    protected boolean mapPropertyNameToFieldName(String propertyName, String fieldName) {
        this.propertyNameToFieldNameMapping.put(propertyName, fieldName);
        return this.propertyNameToFieldNameMapping.containsKey(propertyName);
    }

    protected boolean mapPropertyNameToParameterizedStateChangeCallback(String propertyName, ParameterizedStateChangeCallback callback) {
        this.propertyNameToParameterizedStateChangeCallbackMapping.put(propertyName, callback);
        return this.propertyNameToParameterizedStateChangeCallbackMapping.containsKey(propertyName);
    }

    protected void processChange(String propertyName, Object oldValue, Object newValue) {
        this.processChange(propertyName, oldValue, newValue, null);
    }

    protected void processChange(String propertyName, Object oldValue, Object newValue, StateChangeCallback callback) {
        try {
            PropertyChangeEvent event = this.newPropertyChangeEvent(propertyName, oldValue, newValue);
            this.fireVetoableChange(event);
            if (callback != null) {
                callback.changeState();
            } else if (this.propertyNameToParameterizedStateChangeCallbackMapping.containsKey(propertyName)) {
                this.propertyNameToParameterizedStateChangeCallbackMapping.get(propertyName).changeState(newValue);
            } else {
                this.changeState(propertyName, newValue);
            }
            this.firePropertyChange(event);
            this.fireChange();
        }
        catch (PropertyVetoException e) {
            throw new IllegalPropertyValueException(String.format("The new value (%1$s) for property (%2$s) on Bean (%3$s) is not valid!", newValue, propertyName, this.getClass().getName()), e);
        }
    }

    protected void removeChangeListener(ChangeListener listener) {
        this.changeSupport.remove(listener);
    }

    protected void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(listener);
    }

    protected void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(propertyName, listener);
    }

    protected String unmapPropertyNameToFieldName(String propertyName) {
        return this.propertyNameToFieldNameMapping.remove(propertyName);
    }

    protected boolean unmapPropertyNameToParameterizedStateChangeCallback(String propertyName) {
        return this.propertyNameToParameterizedStateChangeCallbackMapping.remove(propertyName) != null;
    }

    protected static interface ParameterizedStateChangeCallback<T> {
        public void changeState(T var1);
    }

    protected static interface StateChangeCallback {
        public void changeState();
    }
}

