/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.beans.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.cp.elements.beans.event.ChangeEvent;
import org.cp.elements.beans.event.ChangeListener;
import org.cp.elements.lang.Assert;

public class ChangeSupport
implements Iterable<ChangeListener>,
Serializable {
    private final transient List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final Object source;

    public ChangeSupport(Object source) {
        Assert.notNull(source, "Source cannot be null", new Object[0]);
        this.source = source;
    }

    protected Object getSource() {
        return this.source;
    }

    public boolean add(ChangeListener listener) {
        return listener != null && this.changeListeners.add(listener);
    }

    public boolean contains(ChangeListener listener) {
        return this.changeListeners.contains(listener);
    }

    protected ChangeEvent createChangeEvent(Object source) {
        return new ChangeEvent(source);
    }

    public void fireChangeEvent() {
        ChangeEvent event = this.createChangeEvent(this.getSource());
        for (ChangeListener listener : this) {
            listener.stateChanged(event);
        }
    }

    public boolean hasListeners() {
        return !this.changeListeners.isEmpty();
    }

    @Override
    public Iterator<ChangeListener> iterator() {
        return Collections.unmodifiableList(this.changeListeners).iterator();
    }

    public boolean remove(ChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public int size() {
        return this.changeListeners.size();
    }
}

