/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.beans.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.cp.elements.lang.ObjectUtils;

public class ChangeTracker
implements Iterable<String>,
PropertyChangeListener {
    private final Map<String, Integer> objectStateMap = new TreeMap<String, Integer>();

    public boolean isModified() {
        return !this.objectStateMap.isEmpty();
    }

    public boolean isModified(String propertyName) {
        return this.objectStateMap.containsKey(propertyName);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.objectStateMap.containsKey(event.getPropertyName())) {
            if (this.objectStateMap.get(event.getPropertyName()) == ObjectUtils.hashCode(event.getNewValue())) {
                this.objectStateMap.remove(event.getPropertyName());
            }
        } else if (!ObjectUtils.equalsIgnoreNull(event.getOldValue(), event.getNewValue())) {
            this.objectStateMap.put(event.getPropertyName(), ObjectUtils.hashCode(event.getOldValue()));
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.objectStateMap.keySet()).iterator();
    }
}

