/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.biz.rules;

import org.cp.elements.biz.rules.Rule;
import org.cp.elements.lang.Assert;

public abstract class AbstractRule<T, ID extends Comparable<ID>>
implements Rule<T, ID> {
    protected static final boolean DEFAULT_EXPECTED_OUTCOME = true;
    protected static final boolean DEFAULT_THROW_EXCEPTION_ON_FAILURE = false;
    private volatile boolean expectedOutcome = true;
    private volatile boolean throwExceptionOnFailure = false;
    private volatile ID id;

    @Override
    public ID getId() {
        Assert.state(this.id != null, "The identifier for Rule ({0}) was not properly initialized!", this.getClass().getName());
        return this.id;
    }

    @Override
    public final void setId(ID id) {
        Assert.notNull(id, "The identifier for Rule ({0}) cannot be null!", this.getClass().getName());
        this.id = id;
    }

    @Override
    public boolean isNew() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    @Override
    public boolean getExpectedOutcome() {
        return this.expectedOutcome;
    }

    protected final void setExpectedOutcome(boolean expectedOutcome) {
        this.expectedOutcome = expectedOutcome;
    }

    @Override
    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    protected final void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }
}

