/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.context.configure;

import org.cp.elements.context.configure.Configuration;
import org.cp.elements.context.configure.ConfigurationException;
import org.cp.elements.data.conversion.ConversionException;
import org.cp.elements.data.conversion.ConversionService;
import org.cp.elements.data.conversion.ConversionServiceAware;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.StringUtils;

public abstract class AbstractConfiguration
implements Configuration,
ConversionServiceAware {
    protected static final boolean DEFAULT_REQUIRED = true;
    protected static final boolean NOT_REQUIRED = false;
    private final Configuration parent;
    private ConversionService conversionService;

    public AbstractConfiguration() {
        this.parent = null;
    }

    public AbstractConfiguration(Configuration parent) {
        this.parent = parent;
    }

    protected ConversionService getConversionService() {
        Assert.state(this.conversionService != null, "The ConversionService was not properly initialized!", new Object[0]);
        return this.conversionService;
    }

    @Override
    public final void setConversionService(ConversionService conversionService) {
        Assert.notNull(conversionService, "The ConversionService used to support this Configuration cannot be null!", new Object[0]);
        this.conversionService = conversionService;
    }

    protected Configuration getParent() {
        return this.parent;
    }

    protected <T> T convert(String value, Class<T> type) {
        Assert.notNull(type, "The Class type to convert the String value to cannot be null!", new Object[0]);
        if (this.getConversionService().canConvert(String.class, type)) {
            return this.getConversionService().convert(value, type);
        }
        throw new ConversionException(String.format("Cannot convert String value (%1$s) into a value of type (%2$s)!", value, type.getName()));
    }

    protected String defaultIfUnset(String value, String defaultValue) {
        return StringUtils.hasText(value) ? value : defaultValue;
    }

    @Override
    public boolean isPresent(String propertyName) {
        for (String configurationPropertyName : this) {
            if (!configurationPropertyName.equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSet(String propertyName) {
        return StringUtils.hasText(this.doGetPropertyValue(propertyName));
    }

    @Override
    public String getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, true);
    }

    @Override
    public String getPropertyValue(String propertyName, boolean required) {
        String propertyValue = this.doGetPropertyValue(propertyName);
        if (StringUtils.isBlank(propertyValue) && this.getParent() != null) {
            propertyValue = this.getParent().getPropertyValue(propertyName, required);
        }
        if (StringUtils.isBlank(propertyValue) && required) {
            throw new ConfigurationException(String.format("The property (%1$s) is required!", propertyName));
        }
        return this.defaultIfUnset(propertyValue, null);
    }

    @Override
    public String getPropertyValue(String propertyName, String defaultPropertyValue) {
        return this.defaultIfUnset(this.getPropertyValue(propertyName, false), defaultPropertyValue);
    }

    @Override
    public <T> T getPropertyValueAs(String propertyName, Class<T> type) {
        return this.convert(this.getPropertyValue(propertyName, true), type);
    }

    @Override
    public <T> T getPropertyValueAs(String propertyName, boolean required, Class<T> type) {
        try {
            return this.convert(this.getPropertyValue(propertyName, required), type);
        }
        catch (ConversionException e) {
            if (required) {
                throw new ConfigurationException(String.format("Failed to get the value of configuration setting property (%1$s) as type (%2$s)!", propertyName, ClassUtils.getName(type)), e);
            }
            return null;
        }
    }

    @Override
    public <T> T getPropertyValueAs(String propertyName, T defaultPropertyValue, Class<T> type) {
        try {
            return (T)ObjectUtils.defaultIfNull(this.convert(this.getPropertyValue(propertyName, false), type), defaultPropertyValue);
        }
        catch (ConversionException ignore) {
            return defaultPropertyValue;
        }
    }

    protected abstract String doGetPropertyValue(String var1);
}

