/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.context.configure.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import org.cp.elements.context.configure.AbstractConfiguration;
import org.cp.elements.context.configure.Configuration;
import org.cp.elements.lang.Assert;

public class PropertiesConfiguration
extends AbstractConfiguration {
    private final Properties properties;

    public PropertiesConfiguration(File propertiesFile) throws IOException {
        this(propertiesFile, null);
    }

    public PropertiesConfiguration(File propertiesFile, Configuration parent) throws IOException {
        super(parent);
        Assert.notNull(propertiesFile, "The file to load properties from cannot be null!", new Object[0]);
        this.properties = new Properties();
        this.properties.load(new FileInputStream(propertiesFile));
    }

    public PropertiesConfiguration(Properties properties) {
        this(properties, null);
    }

    public PropertiesConfiguration(Properties properties, Configuration parent) {
        super(parent);
        Assert.notNull(properties, "The Properties object used to back this Configuration cannot be null!", new Object[0]);
        this.properties = properties;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isPresent(String propertyName) {
        return this.getProperties().containsKey(propertyName);
    }

    @Override
    protected String doGetPropertyValue(String propertyName) {
        return this.getProperties().getProperty(propertyName);
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.getProperties().stringPropertyNames()).iterator();
    }
}

