/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.caching;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.Identifiable;
import org.cp.elements.lang.Nameable;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.CollectionUtils;
import org.cp.elements.util.MapUtils;

public interface Cache<KEY extends Comparable<KEY>, VALUE>
extends Iterable<VALUE>,
Nameable<String> {
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public void clear() {
        this.evictAll((Iterable<KEY>)this.keys());
    }

    public boolean contains(KEY var1);

    default public boolean containsAll(KEY ... keys) {
        return ArrayUtils.isNotEmpty(keys) && Arrays.stream(ArrayUtils.nullSafeArray(keys)).allMatch(this::contains);
    }

    default public boolean containsAll(Iterable<KEY> keys) {
        return CollectionUtils.isNotEmpty(keys) && StreamSupport.stream(CollectionUtils.nullSafeIterable(keys).spliterator(), false).allMatch(this::contains);
    }

    default public boolean containsAny(KEY ... keys) {
        return Arrays.stream(ArrayUtils.nullSafeArray(keys)).anyMatch(this::contains);
    }

    default public boolean containsAny(Iterable<KEY> keys) {
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(keys).spliterator(), false).anyMatch(this::contains);
    }

    public void evict(KEY var1);

    default public void evictAll(KEY ... keys) {
        Arrays.stream(ArrayUtils.nullSafeArray(keys)).forEach(this::evict);
    }

    default public void evictAll(Iterable<KEY> keys) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(keys).spliterator(), false).forEach(this::evict);
    }

    default public void from(Map<KEY, VALUE> map) {
        MapUtils.nullSafeMap(map).forEach(this::put);
    }

    public VALUE get(KEY var1);

    default public List<VALUE> getAll(KEY ... keys) {
        return Arrays.stream(ArrayUtils.nullSafeArray(keys)).map(this::get).collect(Collectors.toList());
    }

    default public List<VALUE> getAll(Iterable<KEY> keys) {
        return StreamSupport.stream(CollectionUtils.nullSafeIterable(keys).spliterator(), false).map(this::get).collect(Collectors.toList());
    }

    public Set<KEY> keys();

    public void put(KEY var1, VALUE var2);

    default public void put(Identifiable<KEY> entity) {
        Assert.notNull(entity, "Entity is required", new Object[0]);
        Assert.notNull(entity.getId(), "Entity ID is required", new Object[0]);
        this.put(entity.getId(), entity);
    }

    default public void putAll(Identifiable<KEY> ... entities) {
        Arrays.stream(ArrayUtils.nullSafeArray(entities, Identifiable.class)).forEach(this::put);
    }

    default public void putAll(Iterable<Identifiable<KEY>> entities) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(entities).spliterator(), false).forEach(this::put);
    }

    default public VALUE putIfAbsent(KEY key, VALUE value) {
        Assert.notNull(key, "Key is required", new Object[0]);
        if (!this.contains(key)) {
            this.put(key, value);
            return null;
        }
        return this.get(key);
    }

    default public VALUE putIfAbsent(Identifiable<KEY> entity) {
        Assert.notNull(entity, "Entity is required", new Object[0]);
        KEY entityId = entity.getId();
        Assert.notNull(entityId, "Entity ID is required", new Object[0]);
        if (!this.contains(entityId)) {
            this.put(entityId, entity);
            return null;
        }
        return this.get(entityId);
    }

    default public VALUE putIfPresent(KEY key, VALUE newValue) {
        Assert.notNull(key, "Key is required", new Object[0]);
        if (this.contains(key)) {
            VALUE existingValue = this.get(key);
            this.put(key, newValue);
            return existingValue;
        }
        return null;
    }

    default public VALUE putIfPresent(Identifiable<KEY> newEntity) {
        Assert.notNull(newEntity, "Entity is required", new Object[0]);
        KEY entityId = newEntity.getId();
        if (this.contains(entityId)) {
            VALUE existingValue = this.get(entityId);
            this.put(entityId, newEntity);
            return existingValue;
        }
        return null;
    }

    public int size();

    default public Map<KEY, VALUE> toMap() {
        return this.keys().stream().collect(Collectors.toMap(key -> key, this::get));
    }
}

