/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.caching.provider;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.cp.elements.data.caching.AbstractCache;
import org.cp.elements.lang.Assert;
import org.cp.elements.util.MapUtils;

public class ConcurrentMapCache<KEY extends Comparable<KEY>, VALUE>
extends AbstractCache<KEY, VALUE> {
    private final ConcurrentMap<KEY, VALUE> map = new ConcurrentHashMap<KEY, VALUE>();

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(KEY key) {
        return key != null && this.map.containsKey(key);
    }

    @Override
    public void evict(KEY key) {
        if (key != null) {
            this.map.remove(key);
        }
    }

    @Override
    public void from(Map<KEY, VALUE> map) {
        this.map.putAll(MapUtils.nullSafeMap(map));
    }

    @Override
    public VALUE get(KEY key) {
        return key != null ? (VALUE)this.map.get(key) : null;
    }

    @Override
    public Iterator<VALUE> iterator() {
        return Collections.unmodifiableMap(this.map).values().iterator();
    }

    @Override
    public Set<KEY> keys() {
        return Collections.unmodifiableMap(this.map).keySet();
    }

    @Override
    public void put(KEY key, VALUE value) {
        Assert.notNull(key, "Key is required", new Object[0]);
        Assert.notNull(value, "Value is required", new Object[0]);
        this.map.put(key, value);
    }

    @Override
    public VALUE putIfAbsent(KEY key, VALUE value) {
        Assert.notNull(key, "Key is required", new Object[0]);
        Assert.notNull(value, "Value is required", new Object[0]);
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public VALUE putIfPresent(KEY key, VALUE newValue) {
        Assert.notNull(newValue, "Value is required", new Object[0]);
        if (key != null) {
            AtomicReference<Object> oldValueRef = new AtomicReference<Object>(null);
            return (VALUE)(newValue.equals(this.map.computeIfPresent(key, (theKey, oldValue) -> {
                oldValueRef.set(oldValue);
                return newValue;
            })) ? oldValueRef.get() : null);
        }
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Map<KEY, VALUE> toMap() {
        return Collections.unmodifiableMap(this.map);
    }
}

