/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.caching.support;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.cp.elements.data.caching.Cache;
import org.cp.elements.lang.Assert;

public class CacheToMapAdapter<KEY extends Comparable<KEY>, VALUE>
extends AbstractMap<KEY, VALUE> {
    private final Cache<KEY, VALUE> cache;

    public static <KEY extends Comparable<KEY>, VALUE> CacheToMapAdapter<KEY, VALUE> of(Cache<KEY, VALUE> cache) {
        return new CacheToMapAdapter<KEY, VALUE>(cache);
    }

    public CacheToMapAdapter(Cache<KEY, VALUE> cache) {
        Assert.notNull(cache, "Cache is required", new Object[0]);
        this.cache = cache;
    }

    protected Cache<KEY, VALUE> getCache() {
        return this.cache;
    }

    @Override
    public void clear() {
        this.getCache().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getCache().contains((Comparable)key);
    }

    @Override
    public Set<Map.Entry<KEY, VALUE>> entrySet() {
        return new AbstractSet<Map.Entry<KEY, VALUE>>(){

            @Override
            public Iterator<Map.Entry<KEY, VALUE>> iterator() {
                return new Iterator<Map.Entry<KEY, VALUE>>(){
                    private final Iterator<KEY> keys;
                    {
                        this.keys = CacheToMapAdapter.this.getCache().keys().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    @Override
                    public Map.Entry<KEY, VALUE> next() {
                        try {
                            return CacheEntry.of((Comparable)this.keys.next(), CacheToMapAdapter.this.getCache());
                        }
                        catch (NoSuchElementException ignore) {
                            throw new NoSuchElementException("No more cache entries");
                        }
                    }
                };
            }

            @Override
            public int size() {
                return CacheToMapAdapter.this.getCache().size();
            }
        };
    }

    @Override
    public VALUE get(Object key) {
        return this.getCache().get((Comparable)key);
    }

    @Override
    public boolean isEmpty() {
        return this.getCache().isEmpty();
    }

    @Override
    public Set<KEY> keySet() {
        return this.getCache().keys();
    }

    @Override
    public VALUE put(KEY key, VALUE value) {
        VALUE oldValue = this.get(key);
        this.getCache().put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends KEY, ? extends VALUE> map) {
        this.getCache().from(map);
    }

    @Override
    public VALUE putIfAbsent(KEY key, VALUE value) {
        VALUE oldValue = this.get(key);
        this.getCache().putIfAbsent(key, value);
        return oldValue;
    }

    @Override
    public VALUE remove(Object key) {
        VALUE oldValue = this.get(key);
        this.getCache().evict((Comparable)key);
        return oldValue;
    }

    @Override
    public int size() {
        return this.getCache().size();
    }

    @Override
    public Collection<VALUE> values() {
        return new AbstractCollection<VALUE>(){

            @Override
            public Iterator<VALUE> iterator() {
                return CacheToMapAdapter.this.getCache().iterator();
            }

            @Override
            public int size() {
                return CacheToMapAdapter.this.getCache().size();
            }
        };
    }

    protected static class CacheEntry<KEY extends Comparable<KEY>, VALUE>
    implements Map.Entry<KEY, VALUE> {
        private final KEY key;
        private final Cache<KEY, VALUE> cache;

        protected static <KEY extends Comparable<KEY>, VALUE> CacheEntry<KEY, VALUE> of(KEY key, Cache<KEY, VALUE> cache) {
            return new CacheEntry<KEY, VALUE>(key, cache);
        }

        protected CacheEntry(KEY key, Cache<KEY, VALUE> cache) {
            Assert.notNull(key, "Key is required", new Object[0]);
            Assert.notNull(cache, "Cache is required", new Object[0]);
            Assert.state(cache.contains(key), "Key [%1$s] is not contained in Cache [%2$s]", key, cache.getName());
            this.key = key;
            this.cache = cache;
        }

        protected Cache<KEY, VALUE> getCache() {
            return this.cache;
        }

        @Override
        public KEY getKey() {
            return this.key;
        }

        @Override
        public VALUE getValue() {
            return this.getCache().get(this.getKey());
        }

        @Override
        public VALUE setValue(VALUE value) {
            VALUE oldValue = this.getValue();
            this.getCache().put(this.getKey(), value);
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)obj;
            return this.getKey().equals(that.getKey());
        }

        @Override
        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + this.getKey().hashCode();
            return hashValue;
        }

        public String toString() {
            return String.format("%1$s = %2$s", this.getKey(), this.getValue());
        }
    }
}

