/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.caching.support;

import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.cp.elements.data.caching.Cache;
import org.cp.elements.lang.Assert;

public class CachingTemplate<KEY extends Comparable<KEY>, VALUE> {
    private final Cache<KEY, VALUE> cache;
    private ReadWriteLock lock;

    public static <KEY extends Comparable<KEY>, VALUE> CachingTemplate<KEY, VALUE> with(Cache<KEY, VALUE> cache) {
        return new CachingTemplate<KEY, VALUE>(cache);
    }

    public CachingTemplate(Cache<KEY, VALUE> cache) {
        this(cache, null);
    }

    public CachingTemplate(Cache<KEY, VALUE> cache, ReadWriteLock lock) {
        Assert.notNull(cache, "Cache is required", new Object[0]);
        this.cache = cache;
        this.lock = lock != null ? lock : this.newReadWriteLock();
    }

    protected Cache<KEY, VALUE> getCache() {
        return this.cache;
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    protected ReadWriteLock newReadWriteLock() {
        return new ReentrantReadWriteLock();
    }

    public CachingTemplate using(ReadWriteLock lock) {
        this.lock = lock != null ? lock : this.newReadWriteLock();
        return this;
    }

    protected void clear(ReadWriteLock lock) {
        Lock writeLock = lock.writeLock();
        try {
            writeLock.lock();
            this.getCache().clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict(ReadWriteLock lock, KEY key) {
        Lock writeLock = lock.writeLock();
        try {
            writeLock.lock();
            this.getCache().evict(key);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VALUE read(ReadWriteLock lock, KEY key) {
        Lock readLock = lock.readLock();
        try {
            readLock.lock();
            VALUE VALUE = this.getCache().get(key);
            return VALUE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VALUE write(ReadWriteLock lock, KEY key, VALUE value) {
        Lock writeLock = lock.writeLock();
        try {
            writeLock.lock();
            this.getCache().put(key, value);
            VALUE VALUE = value;
            return VALUE;
        }
        finally {
            writeLock.unlock();
        }
    }

    public <T extends VALUE> T withCaching(KEY key, Supplier<VALUE> cacheableOperation) {
        Assert.notNull(key, "Key is required", new Object[0]);
        Assert.notNull(cacheableOperation, "Supplier is required", new Object[0]);
        ReadWriteLock lock = this.getLock();
        return (T)Optional.ofNullable(this.read(lock, key)).orElseGet(() -> Optional.ofNullable(cacheableOperation.get()).map(value -> this.write(lock, key, value)).orElse(null));
    }

    public <T extends VALUE> T withCacheClear(Supplier<VALUE> cacheableOperation) {
        Assert.notNull(cacheableOperation, "Supplier is required", new Object[0]);
        VALUE returnValue = cacheableOperation.get();
        this.clear(this.getLock());
        return (T)returnValue;
    }

    public <T extends VALUE> T withCacheEvict(KEY key, Supplier<VALUE> cacheableOperation) {
        Assert.notNull(cacheableOperation, "Supplier is required", new Object[0]);
        VALUE result = cacheableOperation.get();
        this.evict(this.getLock(), key);
        return (T)result;
    }

    public <T extends VALUE> T withCachePut(KEY key, Supplier<VALUE> cacheableOperation) {
        Assert.notNull(key, "Key is required", new Object[0]);
        Assert.notNull(cacheableOperation, "Supplier is required", new Object[0]);
        return Optional.ofNullable(cacheableOperation.get()).map(value -> this.write(this.getLock(), key, value)).orElse(null);
    }
}

