/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.caching.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.cp.elements.data.caching.AbstractCache;
import org.cp.elements.lang.Assert;
import org.cp.elements.util.MapUtils;

public class MapToCacheAdapter<KEY extends Comparable<KEY>, VALUE>
extends AbstractCache<KEY, VALUE> {
    private final Map<KEY, VALUE> map;

    public static <KEY extends Comparable<KEY>, VALUE> MapToCacheAdapter<KEY, VALUE> of(Map<KEY, VALUE> map) {
        return new MapToCacheAdapter<KEY, VALUE>(map);
    }

    public MapToCacheAdapter(Map<KEY, VALUE> map) {
        Assert.notNull(map, "Map is required", new Object[0]);
        this.map = map;
    }

    protected Map<KEY, VALUE> getMap() {
        return this.map;
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public boolean contains(KEY key) {
        return key != null && this.getMap().containsKey(key);
    }

    @Override
    public void evict(KEY key) {
        if (key != null) {
            this.getMap().remove(key);
        }
    }

    @Override
    public void from(Map<KEY, VALUE> map) {
        this.getMap().putAll(MapUtils.nullSafeMap(map));
    }

    @Override
    public VALUE get(KEY key) {
        return key != null ? (VALUE)this.getMap().get(key) : null;
    }

    @Override
    public Iterator<VALUE> iterator() {
        return this.toMap().values().iterator();
    }

    @Override
    public Set<KEY> keys() {
        return this.toMap().keySet();
    }

    @Override
    public void put(KEY key, VALUE value) {
        Assert.notNull(key, "Key is required", new Object[0]);
        Assert.notNull(value, "Value is required", new Object[0]);
        this.getMap().put(key, value);
    }

    @Override
    public VALUE putIfAbsent(KEY key, VALUE value) {
        Assert.notNull(key, "Key is required", new Object[0]);
        Assert.notNull(value, "Value is required", new Object[0]);
        return this.getMap().putIfAbsent(key, value);
    }

    @Override
    public VALUE putIfPresent(KEY key, VALUE newValue) {
        Assert.notNull(newValue, "Value is required", new Object[0]);
        AtomicReference<Object> oldValueRef = new AtomicReference<Object>(null);
        return (VALUE)(newValue.equals(this.map.computeIfPresent(key, (theKey, oldValue) -> {
            oldValueRef.set(oldValue);
            return newValue;
        })) ? oldValueRef.get() : null);
    }

    @Override
    public int size() {
        return this.getMap().size();
    }

    @Override
    public Map<KEY, VALUE> toMap() {
        return Collections.unmodifiableMap(MapUtils.nullSafeMap(this.getMap()));
    }
}

