/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion;

import org.cp.elements.data.conversion.AbstractConverterRegistry;
import org.cp.elements.data.conversion.ConversionService;
import org.cp.elements.data.conversion.Converter;
import org.cp.elements.lang.ElementsExceptionsFactory;

public abstract class AbstractConversionService
extends AbstractConverterRegistry
implements ConversionService {
    @Override
    public <T> T convert(Object value, Class<T> toType) {
        for (AbstractConverterRegistry.ConverterDescriptor descriptor : this.getRegistry().keySet()) {
            Converter<T, T> converter = descriptor.getConverter();
            if (!converter.canConvert(value, toType)) continue;
            if (descriptor.isExactConversion(toType)) {
                return toType.cast(converter.convert(value));
            }
            return toType.cast(converter.convert(value, toType));
        }
        throw ElementsExceptionsFactory.newConversionException("Cannot convert [%1$s] into Object of type [%2$s]", value, toType.getName());
    }
}

