/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import org.cp.elements.data.conversion.ConversionService;
import org.cp.elements.data.conversion.Converter;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.RuntimeExceptionsFactory;
import org.cp.elements.util.ArrayUtils;

public abstract class AbstractConverter<S, T>
implements Converter<S, T> {
    private ConversionService conversionService;
    private final Class<?> sourceType;
    private final Class<?> targetType;

    public AbstractConverter() {
        ParameterizedType parameterizedType = Arrays.stream(ArrayUtils.nullSafeArray(this.getClass().getGenericInterfaces(), Type.class)).filter(this::isParameterizedConverterType).findFirst().map(it -> (ParameterizedType)it).orElseGet(() -> {
            Type genericSuperclass = this.getClass().getGenericSuperclass();
            return this.isParameterizedConverterType(genericSuperclass) ? (ParameterizedType)genericSuperclass : null;
        });
        this.sourceType = parameterizedType != null ? ClassUtils.toRawType(parameterizedType.getActualTypeArguments()[0]) : Object.class;
        this.targetType = parameterizedType != null ? ClassUtils.toRawType(parameterizedType.getActualTypeArguments()[1]) : Object.class;
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    protected Optional<ConversionService> getConversionService() {
        return Optional.ofNullable(this.conversionService);
    }

    protected ConversionService resolveConversionService() {
        return this.getConversionService().orElseThrow(() -> RuntimeExceptionsFactory.newIllegalStateException("No ConversionService was configured", new Object[0]));
    }

    protected boolean isAssignableTo(Class<?> fromType, Class<?> ... toTypes) {
        for (Class<?> toType : ArrayUtils.nullSafeArray(toTypes, Class.class)) {
            if (!ClassUtils.assignableTo(fromType, toType)) continue;
            return true;
        }
        return false;
    }

    protected boolean isParameterizedConverterType(Type type) {
        return type instanceof ParameterizedType && ClassUtils.assignableTo(ClassUtils.toRawType(type), Converter.class);
    }

    protected Class<?> getSourceType() {
        return this.sourceType;
    }

    protected Class<?> getTargetType() {
        return this.targetType;
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        throw new UnsupportedOperationException("Operation Not Supported");
    }

    @Override
    public T convert(S value) {
        throw new UnsupportedOperationException("Operation Not Supported");
    }
}

