/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cp.elements.data.conversion.ConversionService;
import org.cp.elements.data.conversion.Converter;
import org.cp.elements.data.conversion.ConverterRegistry;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ClassUtils;
import org.cp.elements.lang.ObjectUtils;
import org.cp.elements.lang.Registry;
import org.cp.elements.util.ArrayUtils;

public abstract class AbstractConverterRegistry
implements ConverterRegistry {
    private final Map<ConverterDescriptor, Converter<?, ?>> registry = new ConcurrentHashMap();

    protected Map<ConverterDescriptor, Converter<?, ?>> getRegistry() {
        return this.registry;
    }

    @Override
    public Iterator<Converter<?, ?>> iterator() {
        return this.getRegistry().values().iterator();
    }

    @Override
    public <R extends Registry<Converter<?, ?>>> R register(Converter<?, ?> converter) {
        Assert.notNull(converter, "Converter is required", new Object[0]);
        this.getRegistry().put(ConverterDescriptor.describe(converter), converter);
        if (this instanceof ConversionService) {
            converter.setConversionService((ConversionService)((Object)this));
        }
        return (R)this;
    }

    @Override
    public <R extends Registry<Converter<?, ?>>> R unregister(Converter<?, ?> converter) {
        Iterator<Converter<?, ?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(converter)) continue;
            iterator.remove();
            converter.setConversionService(null);
        }
        return (R)this;
    }

    protected static class ConverterDescriptor {
        private final Class<?> fromType;
        private final Class<?> toType;
        private final Converter<?, ?> converter;

        protected static ConverterDescriptor describe(Converter<?, ?> converter) {
            Assert.notNull(converter, "Converter is required", new Object[0]);
            ParameterizedType parameterizedType = Arrays.stream(ArrayUtils.nullSafeArray(converter.getClass().getGenericInterfaces(), Type.class)).filter(ConverterDescriptor::isParameterizedConverterType).findFirst().map(it -> (ParameterizedType)it).orElseGet(() -> {
                Type genericSuperclass = converter.getClass().getGenericSuperclass();
                return ConverterDescriptor.isParameterizedConverterType(genericSuperclass) ? (ParameterizedType)genericSuperclass : null;
            });
            Assert.notNull(parameterizedType, "Converter [%s] was not properly parameterized", converter.getClass().getName());
            Class<?> fromType = ClassUtils.toRawType(parameterizedType.getActualTypeArguments()[0]);
            Class<?> toType = ClassUtils.toRawType(parameterizedType.getActualTypeArguments()[1]);
            return new ConverterDescriptor(converter, fromType, toType);
        }

        private static boolean isParameterizedConverterType(Type type) {
            return type instanceof ParameterizedType && ClassUtils.assignableTo(ClassUtils.toRawType(type), Converter.class);
        }

        protected ConverterDescriptor(Converter<?, ?> converter, Class<?> fromType, Class<?> toType) {
            Assert.notNull(converter, "Converter is required", new Object[0]);
            Assert.notNull(fromType, "From type is required", new Object[0]);
            Assert.notNull(toType, "To type is required", new Object[0]);
            this.converter = converter;
            this.fromType = fromType;
            this.toType = toType;
        }

        public Converter<?, ?> getConverter() {
            return this.converter;
        }

        public Class getFromType() {
            return this.fromType;
        }

        public Class getToType() {
            return this.toType;
        }

        public boolean isExactConversion(Class targetType) {
            return this.getToType().equals(targetType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConverterDescriptor)) {
                return false;
            }
            ConverterDescriptor that = (ConverterDescriptor)obj;
            return ObjectUtils.equals(this.getFromType(), that.getFromType()) && ObjectUtils.equals(this.getToType(), that.getToType());
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getFromType());
            hashValue = 37 * hashValue + ObjectUtils.hashCode(this.getToType());
            return hashValue;
        }

        public String toString() {
            return String.format("%1$s converts from [%2$s] to [%3$s]", this.getConverter().getClass().getName(), this.getFromType().getName(), this.getToType().getName());
        }
    }
}

