/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion;

import org.cp.elements.data.conversion.ConversionServiceAware;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.ObjectUtils;

public interface Converter<S, T>
extends ConversionServiceAware {
    default public boolean canConvert(Object value, Class<?> toType) {
        return this.canConvert(ObjectUtils.getClass(value), toType);
    }

    public boolean canConvert(Class<?> var1, Class<?> var2);

    public T convert(S var1);

    default public <QT extends T> QT convert(S value, Class<QT> qualifyingType) {
        Assert.notNull(qualifyingType, "Qualifying type is required", new Object[0]);
        try {
            return qualifyingType.cast(this.convert(value));
        }
        catch (ClassCastException cause) {
            throw ElementsExceptionsFactory.newConversionException(cause, "Cannot convert [%1$s] into an Object of type [%2$s]", value, qualifyingType.getName());
        }
    }
}

