/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion;

import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;

public abstract class DefaultableConverter<S, T>
extends AbstractConverter<S, T> {
    private T defaultValue;

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return fromType == null && this.getDefaultValue() != null;
    }

    @Override
    public T convert(S value) {
        T defaultValue = this.getDefaultValue();
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        throw ElementsExceptionsFactory.newConversionException("Cannot convert [%1$s] to [%2$s]", value, this.getTargetType().getName());
    }

    public <CONVERTER extends DefaultableConverter<S, T>> CONVERTER withDefaultValue(T defaultValue) {
        this.setDefaultValue(defaultValue);
        return (CONVERTER)this;
    }
}

