/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.math.BigDecimal;
import java.math.MathContext;
import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;

public class BigDecimalConverter
extends AbstractConverter<String, BigDecimal> {
    private final MathContext mathContext;

    public BigDecimalConverter() {
        this(null);
    }

    public BigDecimalConverter(MathContext mathContext) {
        this.mathContext = mathContext;
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return fromType != null && this.isAssignableTo(fromType, String.class) && BigDecimal.class.equals(toType);
    }

    @Override
    public BigDecimal convert(String value) {
        try {
            return this.mathContext == null ? new BigDecimal(String.valueOf(value).trim()) : new BigDecimal(String.valueOf(value).trim(), this.mathContext);
        }
        catch (NumberFormatException cause) {
            throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid BigDecimal", value);
        }
    }
}

