/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.math.BigInteger;
import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;

public class BigIntegerConverter
extends AbstractConverter<String, BigInteger> {
    private final Integer radix;

    public BigIntegerConverter() {
        this(null);
    }

    public BigIntegerConverter(Integer radix) {
        this.radix = radix;
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return fromType != null && this.isAssignableTo(fromType, String.class) && BigInteger.class.equals(toType);
    }

    @Override
    public BigInteger convert(String value) {
        try {
            return this.radix == null ? new BigInteger(String.valueOf(value).trim()) : new BigInteger(String.valueOf(value).trim(), (int)this.radix);
        }
        catch (NumberFormatException cause) {
            throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid BigInteger", value);
        }
    }
}

