/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.util.Collections;
import java.util.Set;
import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.util.ArrayUtils;
import org.cp.elements.util.CollectionUtils;

public class BooleanConverter
extends DefaultableConverter<Object, Boolean> {
    protected final Set<String> trueValues;

    public BooleanConverter() {
        this(Boolean.TRUE.toString());
    }

    public BooleanConverter(String ... trueValues) {
        this.trueValues = Collections.unmodifiableSet(CollectionUtils.asSet(ArrayUtils.nullSafeArray(trueValues, String.class)));
    }

    protected boolean isTrue(Object value) {
        String valueString = String.valueOf(value).trim();
        return Boolean.parseBoolean(valueString) || this.isTrue(valueString);
    }

    protected boolean isTrue(String value) {
        return this.trueValues.stream().anyMatch(trueValue -> trueValue.equalsIgnoreCase(value));
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return Boolean.class.equals(toType) || Boolean.TYPE.equals(toType);
    }

    @Override
    public Boolean convert(Object value) {
        return value instanceof Boolean ? (Boolean)value : this.isTrue(value) || Boolean.TRUE.equals(this.getDefaultValue());
    }
}

