/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class ByteConverter
extends DefaultableConverter<Object, Byte> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Number.class, String.class) && Byte.class.equals(toType);
    }

    @Override
    public Byte convert(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String && StringUtils.isDigits(value.toString().trim())) {
            try {
                return Byte.parseByte(value.toString().trim());
            }
            catch (NumberFormatException cause) {
                throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid byte", value);
            }
        }
        return (Byte)super.convert(value);
    }
}

