/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import org.cp.elements.data.conversion.DefaultableConverter;

public class CharacterConverter
extends DefaultableConverter<Object, Character> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Character.class, String.class) && Character.class.equals(toType);
    }

    @Override
    public Character convert(Object value) {
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String valueString = value.toString();
            return Character.valueOf(valueString.length() > 0 ? valueString.charAt(0) : (char)'\u0000');
        }
        return (Character)super.convert(value);
    }
}

