/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class DateConverter
extends DefaultableConverter<Object, Date> {
    protected static final String DEFAULT_PATTERN = "MM/dd/yyyy hh:mm:ss a";
    private final DateFormat dateFormat;

    public DateConverter() {
        this(DEFAULT_PATTERN);
    }

    public DateConverter(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    protected DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Calendar.class, Date.class, Number.class, String.class) && Date.class.equals(toType);
    }

    @Override
    public Date convert(Object value) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            String valueString = String.valueOf(value).trim();
            try {
                return StringUtils.isDigits(valueString) ? new Date(Long.parseLong(valueString)) : new Date(this.getDateFormat().parse(valueString).getTime());
            }
            catch (NumberFormatException | ParseException cause) {
                throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid date/time", value);
            }
        }
        return (Date)super.convert(value);
    }
}

