/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class DoubleConverter
extends DefaultableConverter<Object, Double> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Number.class, String.class) && Double.class.equals(toType);
    }

    @Override
    public Double convert(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String && StringUtils.containsDigits(value.toString().trim())) {
            try {
                return Double.parseDouble(value.toString().trim());
            }
            catch (NumberFormatException cause) {
                throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid double", value);
            }
        }
        return (Double)super.convert(value);
    }
}

