/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;

public class EnumConverter
extends AbstractConverter<String, Enum> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return String.class.equals(fromType) && this.isAssignableTo(toType, Enum.class);
    }

    @Override
    public <QT extends Enum> QT convert(String value, Class<QT> enumType) {
        try {
            QT enumInstance = Enum.valueOf(enumType, value);
            return (QT)((Enum)enumType.cast(enumInstance));
        }
        catch (Exception cause) {
            throw ElementsExceptionsFactory.newConversionException(cause, "[%1$s] is not a valid enumerated value of Enum [%2$s]", value, enumType.getName());
        }
    }
}

