/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import org.cp.elements.data.conversion.DefaultableConverter;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.StringUtils;

public class FloatConverter
extends DefaultableConverter<Object, Float> {
    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return this.isAssignableTo(fromType, Number.class, String.class) && Float.class.equals(toType);
    }

    @Override
    public Float convert(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String && StringUtils.containsDigits(value.toString().trim())) {
            try {
                return Float.valueOf(Float.parseFloat(value.toString().trim()));
            }
            catch (NumberFormatException cause) {
                throw ElementsExceptionsFactory.newConversionException(cause, "[%s] is not a valid float", value);
            }
        }
        return (Float)super.convert(value);
    }
}

