/*
 * Decompiled with CFR 0.152.
 */
package org.cp.elements.data.conversion.converters;

import java.util.ServiceLoader;
import org.cp.elements.data.conversion.AbstractConverter;
import org.cp.elements.lang.Assert;
import org.cp.elements.lang.ElementsExceptionsFactory;
import org.cp.elements.lang.Identifiable;
import org.cp.elements.lang.factory.ObjectFactory;
import org.cp.elements.lang.factory.ObjectFactoryAware;
import org.cp.elements.lang.factory.ObjectFactoryReferenceHolder;

public class IdentifiableConverter
extends AbstractConverter<Long, Identifiable<Long>>
implements ObjectFactoryAware {
    private ObjectFactory objectFactory;

    public IdentifiableConverter() {
        this(ObjectFactoryReferenceHolder.hasReference() ? ObjectFactoryReferenceHolder.get() : ServiceLoader.load(ObjectFactory.class).iterator().next());
    }

    public IdentifiableConverter(ObjectFactory objectFactory) {
        this.setObjectFactory(objectFactory);
    }

    @Override
    public final void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    protected ObjectFactory getObjectFactory() {
        Assert.state(this.objectFactory != null, "No ObjectFactory was configured", new Object[0]);
        return this.objectFactory;
    }

    @Override
    public boolean canConvert(Class<?> fromType, Class<?> toType) {
        return Long.class.equals(fromType) && toType != null && Identifiable.class.isAssignableFrom(toType);
    }

    @Override
    public <QT extends Identifiable<Long>> QT convert(Long value, Class<QT> identifiableType) {
        try {
            Identifiable identifiableObject = (Identifiable)this.getObjectFactory().create(identifiableType, new Class[]{Long.class}, new Object[]{value});
            if (identifiableObject.isNew()) {
                identifiableObject.setId(value);
            }
            return (QT)((Identifiable)identifiableType.cast(identifiableObject));
        }
        catch (Throwable cause) {
            throw ElementsExceptionsFactory.newConversionException(cause, "Cannot convert Long [%1$d] into an Object of type [%2$s]", value, identifiableType);
        }
    }
}

